# A Descriptor-Based Multi-Cluster Memory for Test-Time Adaptation

> **Anonymized README for double-blind review.**
> This file intentionally omits author names, affiliations, and external URLs. Usage remains unchanged.

## Requirements

```bash
conda create -n mcmtta python=3.9 pip
conda activate mcmtta
pip install -r requirements.txt
```

## Test-time Adaptation (TTA)

Run the evaluation script:

```bash
./run.sh DATASET ADAPTER [CONFIG_FILE]
```

**Available `DATASET` options**

* `cifar10c`
* `cifar100c`
* `imagenetc`
* `domainnet126`

**Available `ADAPTER` options**

* `source`   # no TTA
* `rotta`
* `rottac2f`
* `petta`
* `pettac2f`
* `resitta`
* `resittac2f`

**Examples**

```bash
./run.sh cifar10c petta
./run.sh cifar100c rotta
./run.sh imagenetc source
```

### Configuration & Paths

* Update dataset paths in the configs under `configs/dataset/` (e.g., `TTA_DATA_DIR` for test data and `SRC_DATA_DIR` for source data).

* For `domainnet126`, place the source-pretrained checkpoint under:

  ```
  ./ckpt/domainnet126/
  ```

  (Use the directory structure expected by this repository; external download links are intentionally omitted.)

* If `[CONFIG_FILE]` is not provided, the default adapter/dataset configs are used.

* You can override options via your project’s config mechanism or command-line flags if supported by your setup.


## Acknowledgements

This implementation adapts common practices from existing test-time adaptation codebases. Specific attributions and links are intentionally omitted to preserve anonymity during review.
