from src.adapter.base_adapter import BaseAdapter
from src.adapter.rotta import RoTTA
from src.adapter.petta import PeTTA
from src.adapter.mytta import MyTTA
from src.adapter.source import Source
from src.adapter.rottac2f import RoTTA_C2FTTA  
from src.adapter.resitta import ResiTTA
from src.adapter.resittac2f import ResiTTAC2F


def build_adapter(cfg) -> type(BaseAdapter):
    print(f"[DEBUG] cfg.ADAPTER.NAME = {cfg.ADAPTER.NAME}")

    if cfg.ADAPTER.NAME == "rotta":
        return RoTTA
    if cfg.ADAPTER.NAME == "petta":
        return PeTTA 
    if cfg.ADAPTER.NAME == "source":
        return Source
    if cfg.ADAPTER.NAME == "mytta":
        return MyTTA
    if cfg.ADAPTER.NAME == "rottac2f":
        return RoTTA_C2FTTA
    if cfg.ADAPTER.NAME == "resitta":
        return ResiTTA
    if cfg.ADAPTER.NAME == "resittac2f":
        return ResiTTAC2F
    else:
        raise NotImplementedError("Implement your own adapter")
