# Experiment Scripts for “Randomised Neural Network Expressivity for Non-Linear PDEs”

This folder contains scripts used to carry out the experiments in the **"Randomised Neural Network Expressivity for non-linear PDEs"** paper.  
We use randomised neural networks (RaNNs) and Physics-Informed Neural Networks (PINNs) to study:

- **Multi-dimensional Porous Medium Equation (PME)** with Barenblatt-type solutions  
- **1D compressible Navier–Stokes** (travelling shock-wave solutions)

Each script is self-contained and exposes its main hyperparameters as global constants near the top.

---

## **PINNA.py**

### **Purpose**
Solve multi-D PME using a Fourier-feature PINN (dimensions 1–5).  
Uses custom near-front collocation + Adam → L-BFGS training.

### **How it works**
- Defines Fourier-feature PINN `PINNnD`  
- Constructs Barenblatt IC/solution  
- Builds PDE/IC/BC collocation sets  
- For each dimension in `D_LIST`, trains multiple runs  
- Logs outputs to text files

### **Key hyperparameters**
**Domain/physics:** `SPATIAL_DIM`, `M_EXPONENT`, `T0_IC`, `T_DOMAIN`, `L_VEC`, `SUPPORT_FRAC`  
**Architecture:** `USE_FOURIER_FEATURES`, `RF_COUNT`, `FOURIER_INIT_SCALE`, `NON_FOURIER_ACTIVATION`, `HIDDEN_DEPTH`, `HIDDEN_WIDTH`, `POSITIVE_HEAD`, `INPUT_SCALES`  
**Training/collocation:** `USE_CUSTOM_COLLOCATION`, `FRONT_BAND_REL`, `LEARNING_RATE`, `NUM_EPOCHS`, `N_PDE`, `N_IC`, `N_BC`, `LAMBDA_PDE`, `LAMBDA_IC`, `LAMBDA_BC`, `LBFGS_*`  
**Dimension overrides:** `D_LIST`, `dim_to_params()`

---

## **PINNB.py (Lower-D PINN)**

### **Purpose**
Alternative PINN for PME (d = 1–5) using a deeper MLP instead of Fourier features.

### **How it works**
- Same PINN structure as PINNA.py  
- Pure MLP architecture with `HIDDEN_DEPTH=4`, `HIDDEN_WIDTH=32`  
- Same collocation and training pipeline  
- Multi-seed training and logging

### **Key hyperparameters**
Mostly identical to PINNA.py except:  
**Architecture defaults:** `HIDDEN_DEPTH=4`, `HIDDEN_WIDTH=32`  

---

## **RNN.py (Random-Features Network for PME)**

### **Purpose**
RaNN approximation of PME using PINN-like losses but **only** the linear readout is trained.  
Supports Fourier/non-Fourier features. Suitable for high dimensions (1–5).

### **How it works**
- Defines `RFNNnD` with fixed random features  
- Computes residual via analytic grad (`pde_residual_fast_nd`) 
- Builds PDE/IC/BC collocation sets  
- Trains via Adam + L-BFGS for multiple dimensions and seeds  
- Logs spacetime and final-time errors

### **Key hyperparameters**
**Domain/physics:** `SPATIAL_DIM`, `M_EXPONENT`, `T0_IC`, `T_DOMAIN`, `L_VEC`, `SUPPORT_FRAC`  
**Architecture:** `USE_FOURIER_FEATURES`, `NON_FOURIER_ACTIVATION`, `NUM_RANDOM_FEATURES`, `FEATURE_SCALE`, `POSITIVE_HEAD`, `INPUT_SCALES`  
**Training:** `USE_CUSTOM_COLLOCATION`, `FRONT_BAND_REL`, `LEARNING_RATE`, `NUM_EPOCHS`, `N_PDE`, `N_IC`, `N_BC`, `LAMBDA_*`, `N_EVAL`, `M_RUNS`  
**Dimension overrides:** `D_LIST`, `hyperparams_for_dim()`

---

## **Error_Rates_NSE.py**

### **Purpose**
Estimate how the relative \( L^2 \) error of a random-features network scales with width for a 1D compressible Navier–Stokes traveling shock.

### **How it works**
- Builds an exact ODE-based travelling wave (`NSTravelingWave`)
- Samples spatio-temporal points (dense near the shock)
- Uses `RFNNnD` features with fixed weights
- Solves optimal linear readout via batched ridge regression
- Sweeps widths and averages multiple runs

### **Key hyperparameters**
**Physics:** `GAMMA`, `EPS`, `MU`, `V_PLUS`, `V_MINUS`, `L_DOMAIN`, `T_DOMAIN`  
**Random features:** `USE_FOURIER_FEATURES`, `FEATURE_SCALE`, `INPUT_SCALES`  
**Experiment scaling:** `N_TRAIN_PER_FEATURE`, `BATCH_SIZE`, `N_TEST_GLOBAL`, `WIDTH_LIST`, `RUNS_PER_WIDTH`

---

## **Error_Rates_PME.py**

### **Purpose**
Estimate how the error of a RaNN scales with width for the 1D PME (Barenblatt solution).

### **How it works**
- Generates Barenblatt solutions  
- Samples global + centre-weighted points  
- Uses `RFNNnD` fixed random features  
- Trains via ridge regression  
- Sweeps widths and logs testing error curves

### **Key hyperparameters**
**Physics:** `SPATIAL_DIM`, `M_EXPONENT`, `T0_IC`, `T_DOMAIN`, `L_VEC`, `SUPPORT_FRAC`  
**Random features:** `USE_FOURIER_FEATURES`, `NON_FOURIER_ACTIVATION`, `FEATURE_SCALE`, `POSITIVE_HEAD`, `INPUT_SCALES`  
**Experiment scaling:** `N_TRAIN_PER_FEATURE`, `BATCH_SIZE`, `N_TEST_GLOBAL`, `WIDTH_LIST`, `RUNS_PER_WIDTH`

---

# **Additional Folder**

The `Additional/` folder contains simplified PINN and RaNN variants for ablation and architecture comparison.  
These scripts solve the PME using **uniform collocation** and **Adam only**.

### **PINN_A_add.py**  
Fourier-feature PINN with optional MLP layers.

### **PINN_B_add.py**  
Standard MLP PINN (no Fourier features).

### **RANN_A.py**  
Fourier-feature random network; only the output layer is trainable.

### **RANN_B.py**  
Non-Fourier random network; identical training flow as RANN_A.

All scripts run multiple independent solves and save results to `.tvt` files.  
Hyperparameters mirror those of the main scripts.

