#!/bin/bash

###----------------------.CIFAR10-ResNet18
dataset='cifar10'
model='resnet18'
forget_mode='non-iid'
forget_classes=(2 5)
#forget_mode='iid'
#forget_classes=(-1)
forget_data_dir='./data/cifar10_forget_indices.pth'
pretrained_dir='./data/pretrained_model_resnet18_cifar10.pth'

###----------------------- General parameters
critic_criteria='weighted_grad'
granularity='channel'

threshold=(1 0.3)
forget_ratio=0.1
python generate_mask.py --model $model\
                        --dataset $dataset\
                        --forget_data_dir $forget_data_dir\
		                    --forget_ratio $forget_ratio\
		                    --forget_mode $forget_mode\
		                    --forget_classes "$(IFS=,; echo "${forget_classes[*]}")"\
                        --pretrained_dir $pretrained_dir\
                        --critic_criteria $critic_criteria\
                        --granularity $granularity\
                        --threshold "$(IFS=,; echo "${threshold[*]}")"\

