import os
import anthropic
import json
from pprint import pprint
import random
from json.decoder import JSONDecodeError
import hashlib

def get_anthropic_client(credentials):
    anthropic_credentials = credentials['anthropic']
    return anthropic.Anthropic(
        api_key=anthropic_credentials["api_key"]
    )

def prompt_model(credentials, model_name, prompt=None, messages=None, max_tokens=None, temperature=None):
    if prompt is None and messages is None:
        raise ValueError("Either prompt or messages must be specified")
    if prompt is not None and messages is not None:
        raise ValueError("Only one of prompt or messages must be specified")
    elif messages is None:
        messages=[{
            "role": "user",
            "content": prompt,
        }]
    client = get_anthropic_client(credentials)
    client_args = {
    }

    if max_tokens:
        client_args["max_tokens"] = max_tokens

    if temperature:
        client_args["temperature"] = temperature

    # chat_completion = client.chat.completions.create(
    #     messages=messages,
    #     model=model_name,
    #     **client_args
    # )

    message = client.messages.create(
        model=model_name,
        messages=messages,
        **client_args
    )

    return message.content[0].text
    
