## Membership Inference Attack in the Face of DataTransformations

### File details

#### attack_*.py
- Implementations of reverse transformation attack algorithms for images (CIFAR-10, SVHN) with transformations. Defense options included.
- Implementations of reverse transformation attack algorithms for Purchase-100 with transformations.

#### mia_utils.py
- Helper functions for transformations: adversarial noises (PGD), JPEG, rotation
- Helper functions for thresholding
- Helper functions for CC and ET attacks
- Helper functions for NN-defense

#### train_*.py
- trainer function for target models and shadow models

#### vgg.py | dataset.py | purchase100.py
- model architectures and datasets

#### gen_logits.ipynb | dnn_*.ipynb
- Example process of generating logits for NN-attack
- Example process of training attack models and evalutions

### Working process
- 1. Training models via train_*.py
- 2. Generate statistics via attack_*.py
- 3. Load statistics and run helper functions in mia_utils.py. Examples can be found in example.ipynb

### Note
This is an anonymized version for paper submission only. The full version will be open-sourced after paper publication.