from .base_metric import create_metric, BaseMetric
from .summary import MetricsSummary
from .mean import MeanAbsoluteError, MeanSquareError, RootMeanSquareError, \
                  SymmetricMeanAbsolutePercentageError, MeanAbsolutePercentageError
from .classification import F1, AUC, Precision, Recall

metric_map = {
    'mae': MeanAbsoluteError,
    'mse': MeanSquareError,
    'rmse': RootMeanSquareError,
    'smape': SymmetricMeanAbsolutePercentageError,
    'mape': MeanAbsolutePercentageError,
    'f1': F1,
    'auc': AUC,
    'recall': Recall,
    'acc': Precision,
}
