# UniGITE

A PyTorch implementation for training and evaluating the model.

## Environment Setup

Create conda environment using the provided YAML file:
```bash
conda env create -f unigte.yml
conda activate unigte
```

## Project Structure
```plaintext
├── ds_configs/
│   └── my_config_0.yaml    # Distributed training config
├── modeling/lluga/
│   └── modeling_gllama.py  # Core model implementation
├── train_unigte.sh         # Training script
├── eval_unigte.sh          # Zero-shot evaluation script
└── run.sh                  # Main execution script
```

## Execution Scripts

### Training
Run distributed training with:
```bash
bash train_unigte.sh
```

### Zero-Shot Evaluation
Run zero-shot inference with:
```bash
bash eval_unigte.sh
```