#!/bin/bash
export CUDA_VISIBLE_DEVICES=0,1
export TORCH_DISTRIBUTED_DEBUG=DETAIL
wandb offline
# set -x


DATASETS="arxiv,children,computer,arxiv_LP,children_LP,computer_LP,fb15k237,chemblpre"
DATA_WEIGHTS="0.5,0.5,0.5,0.2,0.2,0.2,0.6,0.5"
SEED=42
LR=2e-4
PROJ_LR=2e-4
GRAPH_LR=2e-3
EPOCH=1
BATCH_SIZE=2
MAX_GRAD_NORM=10
ACC_STEP=2
MEM_NUM=64
RUN_NAME=""

TAG="${LR}.B${BATCH_SIZE}.E${EPOCH}.S${SEED}.${RUN_NAME}"
OUTPUT_MODEL_DIR="/UniGTE/ft-models/${TAG}"

TIME=$(date +"%m%d%H%M")


accelerate launch \
  --config_file /UniGTE/ds_configs/my_config_0.yaml \
  ./run_unigte.py \
    --gt_enocder_path "/model/vicuna-7b-v1.5" \
    --llm_path "/model/vicuna-7b-v1.5" \
    --memory_token_nums "${MEM_NUM}" \
    --datasets "${DATASETS}" \
    --data_weights "${DATA_WEIGHTS}" \
    --use_peft True \
    --inference False \
    --fix_encoder False \
    --fix_mem False \
    --pure_icae False \
    --bf16 True \
    --model_arch "vicuna" \
    --output_dir "${OUTPUT_MODEL_DIR}" \
    --seed "${SEED}" \
    --learning_rate ${LR} \
    --proj_learning_rate ${PROJ_LR} \
    --graph_learning_rate ${GRAPH_LR} \
    --lr_scheduler_type 'cosine' \
    --warmup_ratio 0.03 \
    --num_train_epochs ${EPOCH} \
    --per_device_train_batch_size ${BATCH_SIZE} \
    --max_grad_norm ${MAX_GRAD_NORM} \
    --gradient_accumulation_steps ${ACC_STEP} \
    --run_name ${RUN_NAME} \
