import sys

from fuzzywuzzy import fuzz


def match_label(label):
    label_list = [
        'cs.AI, Artificial Intelligence',
        'cs.CL, Computation and Language',
        'cs.CC, Computational Complexity',
        'cs.CE, Computational Engineering, Finance, and Science',
        'cs.CG, Computational Geometry',
        'cs.GT, Computer Science and Game Theory',
        'cs.CV, Computer Vision and Pattern Recognition',
        'cs.CY, Computers and Society',
        'cs.CR, Cryptography and Security',
        'cs.DS, Data Structures and Algorithms',
        'cs.DB, Databases',
        'cs.DL, Digital Libraries',
        'cs.DM, Discrete Mathematics',
        'cs.DC, Distributed, Parallel, and Cluster Computing',
        'cs.ET, Emerging Technologies',
        'cs.FL, Formal Languages and Automata Theory',
        'cs.GL, General Literature',
        'cs.GR, Graphics',
        'cs.AR, Hardware Architecture',
        'cs.HC, Human-Computer Interaction',
        'cs.IR, Information Retrieval',
        'cs.IT, Information Theory',
        'cs.LO, Logic in Computer Science',
        'cs.LG, Machine Learning',
        'cs.MS, Mathematical Software',
        'cs.MA, Multiagent Systems',
        'cs.MM, Multimedia',
        'cs.NI, Networking and Internet Architecture',
        'cs.NE, Neural and Evolutionary Computing',
        'cs.NA, Numerical Analysis',
        'cs.OS, Operating Systems',
        'cs.OH, Other Computer Science',
        'cs.PF, Performance',
        'cs.PL, Programming Languages',
        'cs.RO, Robotics',
        'cs.SI, Social and Information Networks',
        'cs.SE, Software Engineering',
        'cs.SD, Sound',
        'cs.SC, Symbolic Computation',
        'cs.SY, Systems and Control'
    ]
    label_scores = [[fuzz.partial_ratio(label, _label), _label] for _label in label_list]
    max_match_score, match_match_label = max(label_scores, key=lambda x:x[0])
    if max_match_score != 1.:
        return label
    return match_match_label

if __name__ == '__main__':
    total, correct = 0., 0.
    for data in open(sys.argv[1]):
        parts = data.strip().split('\t')
        if parts[0] == '1':
            correct += 1
        elif match_label(parts[2]) == parts[1]:
            correct += 1
        total += 1
    print(f'{correct} / {total} = {correct/total:.2%}')