#!/bin/bash

#model_path="/data/persist/models/llama2-7b"
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b")
#model_paths=("/data/persist/models/alpaca-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
model_paths=("/data/persist/models/vicuna/vicuna-13b-v1.3")
#methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
#methods=("rerope" "leaky-rerope" "lm-infinite" "weave-v10")
methods=("leaky-rerope" "lm-infinite" "weave-v10")
dataset="pile"
datatset_name="pile"
batch_size=1
log_dir="../logs"
cuda="0"
seed=0

source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for model_path in "${model_paths[@]}"; do
  echo "############################ run speed-memory task: $model_path ########################"
  for method in "${methods[@]}"; do
    echo "############################ run speed-memory task: $method ############################"
    current_date=$(date "+%Y-%m-%d_%H-%M-%S")

    save_file="stats_max-15000_min-1000_rope-12000_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
    python_command="python evaluate_ppl.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

    echo $python_command
    eval $python_command || \
      echo "completed, but continuing..."
  done
done





