import configparser
import json

import matplotlib.pyplot as plt
import os, sys
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
BASE_DIR = os.path.dirname(BASE_DIR)
sys.path.append(BASE_DIR)

import argparse
import pickle
from utils.utils import set_seed, read_config_file
import numpy as np
import os
import matplotlib.patheffects as pe

linestyles = ['--', '-.', ':', 'solid', 'dashed', 'dashdot', 'dotted', '-', '--', '-.', ':', 'solid', 'dashed', 'dashdot', 'dotted']
markers = ['o', '^', 's', 'D', 'v', 'p', '*', 'x', 'o', '^', 's', 'D', 'v', 'p', '*', 'x']
colors = ['blue', 'green', 'purple', 'orange', 'brown', 'pink', 'red', 'gray', 'blue', 'green', 'red', 'purple', 'orange', 'brown', 'pink', 'gray']

colors = ['#CFE5FD', '#FDF1DB', '#F1E7EF', '#6BA5D7', '#EDAD6D', '#AC78A9', '#945A28', 'gray', 'blue', 'green', 'red', 'purple']

colors = ['#BD9273', '#CCA29F', '#F3975F', '#54936D', '#98B8DD', '#A9B98B', '#797979', 'gray', 'blue', 'green', 'red', 'purple']

colors = ['#797979', '#A9B98B', '#98B8DD', '#54936D', '#BD9273', '#CCA29F', '#F3975F', 'gray']

labels = [
    "Origin",
    "ReRoPE",
    "Leaky-ReRoPE",
    "Dynamic-NTK",
    "LM-Infinite",
    "Streaming-LLM",
    "Mesa-Extrapolation",
    "other"
]

label_setting = {}
for label, linestyle, marker, color in zip(labels, linestyles, markers, colors):
    label_setting[label] = {
        "linestyle": linestyle,
        "marker": marker,
        "color": color
    }

print(label_setting)


def handle_subplot_data(files, labels, smooth_gamma):
    results = []
    for _filename, _label in zip(files, labels):
        with open(_filename, "rb") as f:
            data = pickle.load(f)["nll_stats_token"]
            smoothed = [0]
            var_values = []
            for _d in data.values():
                smoothed.append(
                    _d["mean"] * (1 - smooth_gamma) +
                    smoothed[-1] * smooth_gamma
                )
                var_values.append(_d["var"])
            smoothed.pop(0)

            y = np.array(smoothed)
            var_values = np.array(var_values)

            # # 找到NaN值的索引
            # nan_indices = np.isnan(y)
            # # # 删除NaN值
            # # y = np.delete(y, nan_indices)
            #
            # # 将NaN值替换为0
            # y = np.nan_to_num(y, nan=0)

            results.append((None, y, var_values, _label))

    return results

def main(args=None):

    all_labels = []  # 用于存储所有图例标签
    handles = []

    # 创建大图和两行三列的子图
    fig, axes = plt.subplots(nrows=1, ncols=3, figsize=(20, 5), sharey='all')

    files_list = args.files_list
    for id, config_file in enumerate(files_list):


        config = read_config_file(config_file)
        files = config['General']['files']
        labels = config['General']['labels']
        smooth_gamma = config['General']['smooth_gamma']
        model_name = config['General']['model_name']

        results = handle_subplot_data(files=files, labels=labels, smooth_gamma=smooth_gamma)

        # 在每个子图中绘制数据
        # idx = id // 3
        idy = id % 3
        for result in results:
            x, y, var_values, label = result[0], result[1], result[2], result[3]


            if label in label_setting.keys():
                # plot_line,  = axes[idy].plot(y, label=label, linewidth=1, linestyle=label_setting[label]["linestyle"], marker=label_setting[label]["marker"], color=label_setting[label]["color"],
                #                                   markersize=1)
                plot_line,  = axes[idy].plot(y, label=label, linewidth=1, marker=label_setting[label]["marker"], color=label_setting[label]["color"],
                                                  markersize=1)
            else:
                # plot_line,  = axes[idy].plot(y, label=label, linewidth=1, linestyle=label_setting["other"]["linestyle"],
                #                     marker=label_setting["other"]["marker"], color=label_setting["other"]["color"], markersize=1)
                plot_line, = axes[idy].plot(y, label=label, linewidth=1,
                                            marker=label_setting["other"]["marker"],
                                            color=label_setting["other"]["color"], markersize=1)

            # axes[idy].fill_between(y-(var_values), y+(var_values), label=label, alpha=0.9, color=plot_line.get_color())

            if label not in all_labels:
                all_labels.append(label)
                handles.append(plot_line)


        axes[idy].set_title(model_name, fontsize=14)
        max_len = 16 * 1024
        x = np.arange(0, max_len, 1024)
        axes[idy].set_xticks(np.array(x), [str(int(l / 1024)) + "k" if int(l / 1024) % 3 == 2 else "" for l in x], fontsize=12)

        # 优化子图效果，添加浅色边框
        axes[idy].spines['top'].set_color('lightgrey')
        axes[idy].spines['right'].set_color('lightgrey')
        axes[idy].spines['bottom'].set_color('lightgrey')
        axes[idy].spines['left'].set_color('lightgrey')

        axes[idy].spines['right'].set_path_effects([pe.withStroke(linewidth=2, foreground='grey')])  # 添加立体效果
        axes[idy].spines['bottom'].set_path_effects([pe.withStroke(linewidth=2, foreground='grey')])  # 添加立体效果

        # 最大训练长度
        if idy == 1:
            axes[idy].axvline(4096, color='white', linestyle='dashdot', linewidth=4.0, zorder=1, marker='o', markersize=4)
        else:
            axes[idy].axvline(2048, color='white', linestyle='dashdot', linewidth=4.0, zorder=1, marker='o',
                              markersize=4)

        # # 添加立体方框效果
        # for spine in axes[idy].spines.values():
        #     spine.set_edgecolor('lightgrey')  # 设置边框颜色
        #     spine.set_linewidth(1)  # 设置边框宽度
        #     spine.set_path_effects([pe.withStroke(linewidth=5, foreground='lightgrey')])  # 添加立体效果

    # 添加纵坐标标签，仅在两行子图的中间位置显示一次
    fig.text(0.02, 0.5, 'NLL', ha='center', va='center', rotation='vertical', fontsize=14)
    fig.text(0.5, 0.03, 'Token Length', ha='center', va='center', fontsize=14)

    # 调整子图之间的间距
    # plt.subplots_adjust(hspace=0.3)
    plt.subplots_adjust(wspace=0.1, hspace=0.3)
    plt.subplots_adjust(left=0.05, right=0.98, bottom=0.19, top=0.92)

    # plt.ylim(bottom=0, top=16, color="lightgrey")

    fig.legend(handles=handles, labels=all_labels, loc='lower center', bbox_to_anchor=(0.5, 0.055), ncol=len(all_labels), fancybox=True,
               shadow=True)

    # 背景和网格线
    # 设置所有子图的背景色
    for ax in np.ravel(axes):
        ax.set_facecolor('#f8f8f8')  # 设置背景色




    plt.savefig('{}.png'.format("pile-ppl-all-3"))
    # 显示图形
    plt.show()

if __name__ == "__main__":
    files_list = [

        "llama-3b-ppl-pile-result8.json",
        "llama2-7b-ppl-pile-result9.json",
        "vicuna-13b-ppl-pile-result10.json"
    ]
    parser = argparse.ArgumentParser()
    parser.add_argument("-c", "--config_file", type=str, default="../conf/mpt-7b-passkey-mean-var-result13.json")
    parser.add_argument('--files_list', nargs='+', type=str, default=files_list)
    args = parser.parse_args()
    main(args)
