#!/bin/bash

#model_path="/data/persist/models/llama2-7b"
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b")
#model_paths=("/data/persist/models/alpaca-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
#model_paths=("/data/persist/models/mosaicml-mpt-7b")
#model_paths=("/data/persist/models/llama2-7b-chat" "/data/persist/models/vicuna/vicuna-13b-v1.3")
model_paths=("/data/persist/models/llama-3b")
methods=("rerope" "leaky-rerope" "weave-v20" "weave-v10" "old" "lm-infinite" "streaming-llm" "dynamic-ntk" )
#methods=("rerope" "leaky-rerope" "lm-infinite" "weave-v10")
#methods=("weave-v21")
dataset="longeval-lines"
datatset_name="longeval-lines"
batch_size=1
log_dir="../logs"
cuda="1"
seed=0

source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

# 记录开始时间
start_time=$(date +%s)


for model_path in "${model_paths[@]}"; do
  echo "############################ run longeval lines task: $model_path ########################"
  for method in "${methods[@]}"; do
    echo "############################ run longeval lines task: $method ############################"
    current_date=$(date "+%Y-%m-%d_%H-%M-%S")

    # 记录开始时间
    current_start_time=$(date +%s)

    save_file="longeval-lines_log-prompt_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
    python_command="python evaluate_longeval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

    echo $python_command
    eval $python_command || \
      echo "completed, but continuing..."

        # 记录结束时间
    current_end_time=$(date +%s)

    # 计算运行时间差异（以秒为单位）
    current_time_diff=$((current_end_time - current_start_time))

    # 将秒数转换为分钟
    current_minutes_diff=$((current_time_diff / 60))

    # 输出运行时间
    echo "${method} 代码运行时间: ${current_minutes_diff} 分钟"

  done
done


# 记录结束时间
end_time=$(date +%s)

# 计算运行时间差异（以秒为单位）
time_diff=$((end_time - start_time))

# 将秒数转换为分钟
minutes_diff=$((time_diff / 60))

# 输出运行时间
echo "total 代码运行时间: ${minutes_diff} 分钟"




