#!/bin/bash

#model_path="/data/persist/models/vicuna/vicuna-13b-v1.5"
#model_path="/data/persist/models/llama-3b"
model_path="/data/persist/models/mosaicml-mpt-7b"
methods=("old") # "lm-infinite" "weave" "weave1-to-duyan" "weave2-to-duyan")
#dataset="../datas/download_data/pile-deduplicated/train-00000-of-01650-f70471ee3deb09c0.parquet"
#datatset_name="pile"
dataset="/data/persist/dataset/gov_report/test.txt"
datatset_name="gov-report-data"

batch_size=1
log_dir="../logs"
cuda="0"
seed=0



source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="stats_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
  python_command="python evaluate_ppl.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"
  echo $python_command
  eval $python_command || \
    echo "completed, but continuing..."
done




