import torch.nn as nn


class LeNet(nn.Module):
    def __init__(self, num_classes=10):
        super().__init__()

        self.net = nn.Sequential(
            nn.Conv2d(1, 6, kernel_size=5, padding=2),
            nn.ReLU(),
            nn.AvgPool2d(kernel_size=2, stride=2),
            nn.Conv2d(6, 16, kernel_size=5, padding=2),
            nn.ReLU(),
            nn.AvgPool2d(kernel_size=2, stride=2),
            nn.Conv2d(16, 120, kernel_size=5, padding=2),
            nn.ReLU(),
            nn.Flatten(),
            nn.Linear(5880, 84),
            nn.ReLU(),
            nn.Linear(84, num_classes),
        )

    def forward(self, inputs):
        return self.net(inputs)


# class LeNet(nn.Module):
#     def __init__(self, num_classes=10):
#         super().__init__()

#         self.net = nn.Sequential(
#             nn.Conv2d(1, 6, kernel_size=5, padding=2),
#             nn.ReLU(),
#             nn.AvgPool2d(kernel_size=2, stride=2),
#             nn.Conv2d(6, 16, kernel_size=5, padding=2),
#             nn.ReLU(),
#             nn.AvgPool2d(kernel_size=2, stride=2),
#             nn.Flatten(),
#             nn.Linear(784, 120),
#             nn.ReLU(),
#             nn.Linear(120, 84),
#             nn.ReLU(),
#             nn.Linear(84, num_classes),
#         )

#     def forward(self, inputs):
#         return self.net(inputs)
