import typing as tp
from pathlib import Path

import torch
import torchaudio


def save_audios(audios: torch.Tensor, filenames: tp.List[str], output_root: str, sr: int):

    bs, ch, L = audios.shape
    assert len(filenames) == bs

    for idx in range(bs):
        audio = audios[idx].to(torch.float).cpu()
        filename = filenames[idx]
        save_path = f"{output_root}/{filename}.wav"

        # mkdir
        Path(save_path).parent.mkdir(parents=True, exist_ok=True)
        torchaudio.save(save_path, audio, sr, encoding='PCM_F')