import torch
from torch_geometric.data import InMemoryDataset


class SyntheticDataset(InMemoryDataset):
    def __init__(self, root, data_list, transform=None, pre_transform=None):
        self.data_list = data_list
        super(SyntheticDataset, self).__init__(root, transform, pre_transform)
        self.data, self.slices = torch.load(self.processed_paths[0])

    @property
    def raw_file_names(self):
        # You can list files here if you have raw files to process. Otherwise, this can be empty.
        return []

    @property
    def processed_file_names(self):
        # This should return the name of the file where you save the processed dataset.
        return ["data.pt"]

    def download(self):
        # This method downloads the raw data files. You can leave it empty if you don't need to download anything.
        pass

    def process(self):
        # Here, you would convert your `Data` objects (self.data_list) into the format expected by `InMemoryDataset`.
        # Since we're assuming `data_list` is already a list of `Data` objects, you might just need to collate them.
        data, slices = self.collate(self.data_list)

        # Save the collated data for quick loading in the future.
        torch.save((data, slices), self.processed_paths[0])

    def len(self):
        # Return the number of examples in your dataset.
        return len(self.data_list)

    def get(self, idx):
        # This method retrieves the `idx`-th sample from the dataset.
        return self.data_list[idx]
