# https://github.com/snap-stanford/GraphGym/blob/master/graphgym/models/feature_encoder.py

import torch
from ogb.utils.features import get_atom_feature_dims
from torch_geometric.graphgym.register import register_node_encoder


@register_node_encoder("AtomNode")
class AtomFeatureEncoder(torch.nn.Module):
    """
    The atom Encoder used in OGB molecule dataset.

    Args:
        emb_dim (int): Output embedding dimension
        num_classes: None
    """

    def __init__(self, dim_in, emb_dim, num_classes=None):
        super().__init__()

        self.atom_embedding_list = torch.nn.ModuleList()

        for i, dim in enumerate(get_atom_feature_dims()):
            emb = torch.nn.Embedding(dim, emb_dim)
            torch.nn.init.xavier_uniform_(emb.weight.data)
            self.atom_embedding_list.append(emb)

    def forward(self, batch):
        """"""
        encoded_features = 0
        for i in range(batch.x.shape[1]):
            encoded_features += self.atom_embedding_list[i](batch.x[:, i])

        batch.x = encoded_features
        return batch
