import os
import torch
import pyvista as pv
# from random import randint
# from utils.loss_utils import l1_loss, ssim
# from gaussian_renderer import render, network_gui
# import sys
from scene import Scene, GaussianModel
# from utils.general_utils import safe_state
# import uuid
# from tqdm import tqdm
# from utils.image_utils import psnr
# from argparse import ArgumentParser, Namespace
# from arguments import ModelParams, PipelineParams, OptimizationParams
# from plyfile import PlyData, PlyElement
import numpy as np
from scene.gaussian_model import BasicPointCloud
try:
    from torch.utils.tensorboard import SummaryWriter
    TENSORBOARD_FOUND = True
except ImportError:
    TENSORBOARD_FOUND = False


def fetchPly(path):
    plydata = PlyData.read(path)
    vertices = plydata['vertex']
    positions = np.vstack([vertices['x'], vertices['y'], vertices['z']]).T
    # print(positions.shape[0])
    pc_num = positions.shape[0]
    red = np.ones((pc_num)) * 100
    green = np.ones((pc_num)) * 100
    blue = np.ones((pc_num)) * 100

    nx = np.ones((pc_num))
    ny = np.ones((pc_num))
    nz = np.ones((pc_num))

    colors = np.vstack([red, green, blue]).T / 255
    normals = np.vstack([nx, ny, nz]).T
    return BasicPointCloud(points=positions, colors=colors, normals=normals)


def save_pumpkin_and_ficus(pumpkin_path, ficus_path):
    gaussian_pumpkin = GaussianModel(3)
    gaussian_ficus = GaussianModel(3)
    
    gaussian_pumpkin.load_ply(pumpkin_path)
    gaussian_ficus.load_ply(ficus_path)
    
    gaussian_ficus.save_ply_wzy_pumpkinandficus("/home/swu/wzy/gaussian-splatting/gaussians/pumpkin+ficus.ply", gaussian_pumpkin)
    
    
    


# sampling point cloud from mesh
# mesh = o3d.io.read_triangle_mesh("/home/swu/wzy/gaussian-splatting/ball.obj")
# point_cloud = mesh.sample_points_uniformly(number_of_points=203930)
# o3d.io.write_point_cloud("ball-pc.ply", point_cloud)

# load ply
# pc = pv.read("/home/swu/wzy/gaussian-splatting/ball-pc.ply")
# xyz = pc.points
# print(xyz)

# gaussian_path = r'/home/swu/wzy/gaussian-splatting/ficus.ply'
# gaussians = GaussianModel(3)
# gaussians.load_ply(gaussian_path)




# ply_path = r'/home/swu/wzy/gaussian-splatting/ball-pc.ply'
# gaussians = GaussianModel(3)
# gaussians2 = GaussianModel(3)
# gaussians3 = GaussianModel(3)
# gaussians4 = GaussianModel(3)
# gaussians5 = GaussianModel(3)
#
# pcd = fetchPly(ply_path)
# pcd2 = fetchPly(ply_path)
# pcd3 = fetchPly(ply_path)
# pcd4 = fetchPly(ply_path)
# pcd5 = fetchPly(ply_path)
# print(pcd.points)
# pcd2.points[:, :] = pcd.points[:, :] * 0.99
# pcd3.points[:, :] = pcd2.points[:, :] * 0.99
# pcd4.points[:, :] = pcd3.points[:, :] * 0.99
# pcd5.points[:, :] = pcd4.points[:, :] * 0.99
#
# gaussians.create_from_pcd_wzy(pcd)
# gaussians2.create_from_pcd_wzy(pcd2)
# gaussians3.create_from_pcd_wzy(pcd3)
# gaussians4.create_from_pcd_wzy(pcd4)
# gaussians5.create_from_pcd_wzy(pcd5)

# print(gaussians_ball._scaling)
# gaussians.save_ply("/home/swu/wzy/gaussian-splatting/pumpkin-gs.ply")
# gaussians.save_ply_wzy_layers("/home/swu/wzy/gaussian-splatting/ball-gs-5.ply", gaussians2, gaussians3, gaussians4, gaussians5)
#
# print(gaussians._xyz)
# gaussians.save_ply("/home/swu/wzy/gaussian-splatting/pumpkin_gs.ply")
#

pumpkin_path = r"/home/swu/wzy/PhysGaussian/model/pumpkin/point_cloud/iteration_10000/point_cloud.ply"
ficus_path = r"/home/swu/wzy/gaussian-splatting/gaussians/ficus.ply"
water_path = r"/home/swu/wzy/PhysGaussian/gaussians/water-test-one-layer.ply"
# save_pumpkin_and_ficus(pumpkin_path, ficus_path)

pumpkin = GaussianModel(3)
pumpkin.load_ply(pumpkin_path)
print("pumpkin scale: ", pumpkin._scaling[0])
print("pumpkin opacity: ", pumpkin._opacity[0])
# print("pumpkin max scale: ", max(pumpkin._scaling))
# print("pumpkin min scale: ", min(pumpkin._scaling))
# print("pumpkin max opacity: ", max(pumpkin._opacity))
# print("pumpkin min opacity: ", min(pumpkin._opacity))

# water = GaussianModel(3)
# water.load_ply(water_path)
# print("water scale: ", water._scaling)
# print("water max scale: ", max(water._scaling[:, 0]))
# print("water min scale: ", min(water._scaling[:, 0]))




# load gaussian and see its parameters
# gaussian_path = r'/home/swu/wzy/gaussian-splatting/ficus.ply'
# gaussians = GaussianModel(3)
# gaussians.load_ply(gaussian_path)
# print(gaussians._scaling)
# print(max(gaussians._scaling[:]))
# print(min(gaussians._scaling[:]))

# gaussians.save_ply_wzy("/home/swu/wzy/gaussian-splatting/ball-gs.ply", xyz)
# gaussian_ball = GaussianModel(3)
# gaussian_ball.load_ply("/home/swu/wzy/gaussian-splatting/ball-gs.ply")

