import torch
import numpy as np
# from utils.camera_view_utils import *

def transform2origin_specialscale(position_tensor, s):
    min_pos = torch.min(position_tensor, 0)[0]
    max_pos = torch.max(position_tensor, 0)[0]
    max_diff = torch.max(max_pos - min_pos)
    original_mean_pos = (min_pos + max_pos) / 2.0
    print("original")
    print(original_mean_pos)
    scale = 1.0 / max_diff * s
    # print(scale)
    # scale = torch.tensor([s])
    original_mean_pos = original_mean_pos.to(device="cuda")
    scale = scale.to(device="cuda")
    new_position_tensor = (position_tensor - original_mean_pos) * scale
    return new_position_tensor, scale, original_mean_pos

def transform2origin_scale(position_tensor, s):
    min_pos = torch.min(position_tensor, 0)[0]
    max_pos = torch.max(position_tensor, 0)[0]
    max_diff = torch.max(max_pos - min_pos)
    original_mean_pos = (min_pos + max_pos) / 2.0
    print("original")
    print(original_mean_pos)
    # scale = 1.0 / max_diff
    # print(scale)
    scale = torch.tensor([s])
    original_mean_pos = original_mean_pos.to(device="cuda")
    scale = scale.to(device="cuda")
    new_position_tensor = (position_tensor - original_mean_pos) * scale
    return new_position_tensor, scale, original_mean_pos

def transform2origin_no_change_scale(position_tensor):
    min_pos = torch.min(position_tensor, 0)[0]
    max_pos = torch.max(position_tensor, 0)[0]
    max_diff = torch.max(max_pos - min_pos)
    original_mean_pos = (min_pos + max_pos) / 2.0
    print("original")
    print(original_mean_pos)
    # scale = 1.0 / max_diff
    # print(scale)
    scale = torch.tensor([0.5])
    original_mean_pos = original_mean_pos.to(device="cuda")
    scale = scale.to(device="cuda")
    new_position_tensor = (position_tensor - original_mean_pos) * scale
    return new_position_tensor, scale, original_mean_pos

def transform2origin_half(position_tensor):
    min_pos = torch.min(position_tensor, 0)[0]
    max_pos = torch.max(position_tensor, 0)[0]
    max_diff = torch.max(max_pos - min_pos)
    original_mean_pos = (min_pos + max_pos) / 2.0
    print("original")
    print(original_mean_pos)
    scale = (1.0 / max_diff) / 2
    # scale = torch.tensor([1])
    original_mean_pos = original_mean_pos.to(device="cuda")
    scale = scale.to(device="cuda")
    new_position_tensor = (position_tensor - original_mean_pos) * scale
    print(max(new_position_tensor[:,2]))
    print(original_mean_pos)
    return new_position_tensor, scale, original_mean_pos

def transform2origin(position_tensor):
    min_pos = torch.min(position_tensor, 0)[0]
    max_pos = torch.max(position_tensor, 0)[0]
    max_diff = torch.max(max_pos - min_pos)
    original_mean_pos = (min_pos + max_pos) / 2.0
    print("original")
    print(original_mean_pos)
    scale = 1.0 / max_diff
    # scale = torch.tensor([1])
    original_mean_pos = original_mean_pos.to(device="cuda")
    scale = scale.to(device="cuda")
    new_position_tensor = (position_tensor - original_mean_pos) * scale
    # print(max(new_position_tensor[:,2]))
    # print(original_mean_pos)
    return new_position_tensor, scale, original_mean_pos


def undotransform2origin(position_tensor, scale, original_mean_pos):
    return original_mean_pos + position_tensor / scale


def generate_rotation_matrix(degree, axis):
    cos_theta = torch.cos(degree / 180.0 * 3.1415926)
    sin_theta = torch.sin(degree / 180.0 * 3.1415926)
    if axis == 0:
        rotation_matrix = torch.tensor(
            [[1, 0, 0], [0, cos_theta, -sin_theta], [0, sin_theta, cos_theta]]
        )
    elif axis == 1:
        rotation_matrix = torch.tensor(
            [[cos_theta, 0, sin_theta], [0, 1, 0], [-sin_theta, 0, cos_theta]]
        )
    elif axis == 2:
        rotation_matrix = torch.tensor(
            [[cos_theta, -sin_theta, 0], [sin_theta, cos_theta, 0], [0, 0, 1]]
        )
    else:
        raise ValueError("Invalid axis selection")
    return rotation_matrix.cuda()


def generate_rotation_matrices(degrees, axises):
    assert len(degrees) == len(axises)

    matrices = []

    for i in range(len(degrees)):
        matrices.append(generate_rotation_matrix(degrees[i], axises[i]))

    return matrices


def apply_rotation(position_tensor, rotation_matrix):
    rotated = torch.mm(position_tensor, rotation_matrix.T)
    return rotated


def apply_cov_rotation(cov_tensor, rotation_matrix):
    rotated = torch.matmul(cov_tensor, rotation_matrix.T)
    rotated = torch.matmul(rotation_matrix, rotated)
    return rotated


def get_mat_from_upper(upper_mat):
    upper_mat = upper_mat.reshape(-1, 6)
    mat = torch.zeros((upper_mat.shape[0], 9), device="cuda")
    mat[:, :3] = upper_mat[:, :3]
    mat[:, 3] = upper_mat[:, 1]
    mat[:, 4] = upper_mat[:, 3]
    mat[:, 5] = upper_mat[:, 4]
    mat[:, 6] = upper_mat[:, 2]
    mat[:, 7] = upper_mat[:, 4]
    mat[:, 8] = upper_mat[:, 5]

    return mat.view(-1, 3, 3)


def get_uppder_from_mat(mat):
    mat = mat.view(-1, 9)
    upper_mat = torch.zeros((mat.shape[0], 6), device="cuda")
    upper_mat[:, :3] = mat[:, :3]
    upper_mat[:, 3] = mat[:, 4]
    upper_mat[:, 4] = mat[:, 5]
    upper_mat[:, 5] = mat[:, 8]

    return upper_mat


def apply_rotations(position_tensor, rotation_matrices):
    for i in range(len(rotation_matrices)):
        position_tensor = apply_rotation(position_tensor, rotation_matrices[i])
    return position_tensor


def apply_cov_rotations(upper_cov_tensor, rotation_matrices):
    cov_tensor = get_mat_from_upper(upper_cov_tensor)
    for i in range(len(rotation_matrices)):
        cov_tensor = apply_cov_rotation(cov_tensor, rotation_matrices[i])
    return get_uppder_from_mat(cov_tensor)

def shift2centerpoints(position_tensor, shift):
    tensor_shift = torch.tensor([shift], device="cuda")
    return position_tensor + tensor_shift

def undoshift2centerpoints(position_tensor, shift):
    tensor_shift = torch.tensor([shift], device="cuda")
    return position_tensor + tensor_shift

def shift2center1112(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 1.2], device="cuda")
    return position_tensor + tensor111

def shift2center10812(position_tensor):
    tensor111 = torch.tensor([1.0, 0.8, 1.2], device="cuda")
    return position_tensor + tensor111

def shift2center10815(position_tensor):
    tensor111 = torch.tensor([1.0, 0.8, 1.5], device="cuda")
    return position_tensor + tensor111

def shift2center10715(position_tensor):
    tensor111 = torch.tensor([1.0, 0.7, 1.5], device="cuda")
    return position_tensor + tensor111

def shift2center107145(position_tensor):
    tensor111 = torch.tensor([1.0, 0.7, 1.45], device="cuda")
    return position_tensor + tensor111

def shift2center11145(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 1.45], device="cuda")
    return position_tensor + tensor111

def shift2center111(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 1.0], device="cuda")
    return position_tensor + tensor111

def shift2center11035(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.3], device="cuda")
    return position_tensor + tensor111

def shift2center1104(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.4], device="cuda")
    return position_tensor + tensor111

def shift2center1103(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.3], device="cuda")
    return position_tensor + tensor111

def shift2center1102(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.2], device="cuda")
    return position_tensor + tensor111

def shift2center1107(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.7], device="cuda")
    return position_tensor + tensor111

def shift2center1106(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.51], device="cuda")
    return position_tensor + tensor111

def shift2center1061(position_tensor):
    tensor111 = torch.tensor([1.0, 0.51, 1.0], device="cuda")
    return position_tensor + tensor111

def shift2center221(position_tensor):
    tensor221 = torch.tensor([1.0, 2.0, 2.0], device="cuda")
    return position_tensor + tensor221

def undoshift2center221(position_tensor):
    tensor221 = torch.tensor([1.0, 2.0, 2.0], device="cuda")
    return position_tensor - tensor221

def undoshift2center111(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 1.0], device="cuda")
    return position_tensor - tensor111

def undoshift2center1105(position_tensor):
    tensor111 = torch.tensor([1.0, 1.0, 0.6], device="cuda")
    return position_tensor - tensor111

def shift2center1115(position_tensor):
    tensor1115 = torch.tensor([1.0, 1.0, 1.5], device="cuda")
    return position_tensor + tensor1115
def shift2center11315(position_tensor):
    tensor1115 = torch.tensor([1.0, 1.3, 1.5], device="cuda")
    return position_tensor + tensor1115

def shift2height1102(position_tensor):
    minheight = torch.min(position_tensor[:, 2])
    delta = torch.abs(0.2 - minheight)
    tensor1102 = torch.tensor([1.0, 1.0, delta], device="cuda")
    return position_tensor + tensor1102

def shift2height1105(position_tensor):
    minheight = torch.min(position_tensor[:, 2])
    delta = torch.abs(0.5 - minheight)
    tensor1102 = torch.tensor([1.0, 1.0, delta], device="cuda")
    return position_tensor + tensor1102


def shift2center1141(position_tensor):
    tensor1115 = torch.tensor([1.0, 1.4, 1.0], device="cuda")
    return position_tensor + tensor1115

def shift2center1141(position_tensor):
    tensor1115 = torch.tensor([1.0, 1.4, 1.0], device="cuda")
    return position_tensor + tensor1115

# def undo_shift1115(position_tensor):
#     tensor1115 = torch.tensor([1.0, 1.0, 1.5], device="cuda")
#     return position_tensor - tensor1115


def apply_inverse_rotation(position_tensor, rotation_matrix):
    rotated = torch.mm(position_tensor, rotation_matrix)
    return rotated


def apply_inverse_rotations(position_tensor, rotation_matrices):
    for i in range(len(rotation_matrices)):
        R = rotation_matrices[len(rotation_matrices) - 1 - i]
        position_tensor = apply_inverse_rotation(position_tensor, R)
    return position_tensor


def apply_inverse_cov_rotations(upper_cov_tensor, rotation_matrices):
    cov_tensor = get_mat_from_upper(upper_cov_tensor)
    for i in range(len(rotation_matrices)):
        R = rotation_matrices[len(rotation_matrices) - 1 - i]
        cov_tensor = apply_cov_rotation(cov_tensor, R.T)
    return get_uppder_from_mat(cov_tensor)


# input must be (n,3) tensor on cuda
def undo_all_transforms(input, rotation_matrices, scale_origin, original_mean_pos):
    return apply_inverse_rotations(
        undotransform2origin(
            undoshift2center111(input), scale_origin, original_mean_pos
        ),
        rotation_matrices,
    )


def get_center_view_worldspace_and_observant_coordinate(
    mpm_space_viewpoint_center,
    mpm_space_vertical_upward_axis,
    rotation_matrices,
    scale_origin,
    original_mean_pos,
):
    viewpoint_center_worldspace = undo_all_transforms(
        mpm_space_viewpoint_center, rotation_matrices, scale_origin, original_mean_pos
    )
    mpm_space_up = mpm_space_vertical_upward_axis + mpm_space_viewpoint_center
    worldspace_up = undo_all_transforms(
        mpm_space_up, rotation_matrices, scale_origin, original_mean_pos
    )
    world_space_vertical_axis = worldspace_up - viewpoint_center_worldspace
    viewpoint_center_worldspace = np.squeeze(
        viewpoint_center_worldspace.clone().detach().cpu().numpy(), 0
    )
    print("viewpoint_center_worldspace: ", viewpoint_center_worldspace)
    vertical, h1, h2 = generate_local_coord(
        np.squeeze(world_space_vertical_axis.clone().detach().cpu().numpy(), 0)
    )
    observant_coordinates = np.column_stack((h1, h2, vertical))

    return viewpoint_center_worldspace, observant_coordinates

def get_center_view_worldspace_and_observant_coordinate2(
    mpm_space_viewpoint_center,
    mpm_space_vertical_upward_axis,
    rotation_matrices,
    scale_origin,
    original_mean_pos,
):
    viewpoint_center_worldspace = undo_all_transforms(
        mpm_space_viewpoint_center, rotation_matrices, scale_origin, original_mean_pos
    )
    mpm_space_up = mpm_space_vertical_upward_axis + mpm_space_viewpoint_center
    worldspace_up = undo_all_transforms(
        mpm_space_up, rotation_matrices, scale_origin, original_mean_pos
    )
    print("worldspace_up: ", worldspace_up)
    print("viewpoint_center_worldspace: ", viewpoint_center_worldspace)
    world_space_vertical_axis = worldspace_up - viewpoint_center_worldspace
    viewpoint_center_worldspace = np.squeeze(
        viewpoint_center_worldspace.clone().detach().cpu().numpy(), 0
    )

    vertical, h1, h2 = generate_local_coord(
        np.squeeze(world_space_vertical_axis.clone().detach().cpu().numpy(), 0)
    )
    observant_coordinates = np.column_stack((h1, h2, vertical))
    print("observant_coordinates: ", observant_coordinates)

    return viewpoint_center_worldspace, observant_coordinates


def generate_local_coord(normal):
    """
    根据法向量生成局部正交坐标系（vertical, h1, h2）。
    支持numpy和torch输入。
    Args:
        normal: (3,) 单位向量
    Returns:
        vertical, h1, h2: 3个正交单位向量
    """
    import numpy as np
    import torch
    if isinstance(normal, torch.Tensor):
        n = normal / (normal.norm() + 1e-8)
        if torch.abs(n[0]) > torch.abs(n[1]):
            h1 = torch.tensor([-n[2], 0.0, n[0]], dtype=n.dtype, device=n.device)
        else:
            h1 = torch.tensor([0.0, n[2], -n[1]], dtype=n.dtype, device=n.device)
        h1 = h1 / (h1.norm() + 1e-8)
        h2 = torch.cross(n, h1)
        return n, h1, h2
    else:
        n = np.asarray(normal)
        n = n / (np.linalg.norm(n) + 1e-8)
        if abs(n[0]) > abs(n[1]):
            h1 = np.array([-n[2], 0.0, n[0]], dtype=n.dtype)
        else:
            h1 = np.array([0.0, n[2], -n[1]], dtype=n.dtype)
        h1 = h1 / (np.linalg.norm(h1) + 1e-8)
        h2 = np.cross(n, h1)
        return n, h1, h2
