## Installation
This repository is tested on Python 3.9.16.  
You should install this repository on a virtual environment. All dependencies can be installed as follows:
```
pip install -r requirements.txt
```

## Datasets
The maze and blocksworld data are included in `data` folder. Each sample is a json, describing the start state, goal state, and the system 1/2 traces on which the models will be trained.

## Experiments on Maze Navigation
To run experiments on maze navigation, check out the scripts inside `scripts/maze`. 

For example, the command to train a system-1 model is:
```
bash scrips/maze/train_sys1.sh
```
Then you can evaluate the model using the following command:
```
bash scrips/maze/eval_sys1.sh
```

To train and evaluate our final System-1.5 model with sub-goal decomposition, first train a System-1 model and a System-2 model. Then execute the following commands:
```
bash scrips/maze/train_sys1.5_sg.sh
bash scrips/maze/eval_sys1.5_sg.sh
```

You can train any System-1.x model by just setting the value of x. Similarly, you can alter the search algorithm by passing `--search_algo dfs/bfs`.

## Experiments on Blocksworld
Experiments on Blocksworld follow a similar pattern. Check out the scripts inside `scrips/blocksworld`.
```
