function [fe,fi,xhat_e,xhat_i,re,ri] = net_fun(dt,sigmav,mu,tau_vec,s,w,C,D)

% integration of the membrane potential for E and I neurons

M=size(s,1);
T=size(s,2);
N=size(w{1},2);
Ni=size(w{2},2);

lambda_e=1/tau_vec(1);
lambda_i=1/tau_vec(2);
alpha_e=1/tau_vec(3);
alpha_i=1/tau_vec(4);

delta_e=mu*(lambda_e-alpha_e);            % multiplies local current in E 
delta_i=mu*(lambda_i-alpha_i);            % multipies local current in I 
delta_ie=(lambda_i - lambda_e);           % multiplies slow E-to-I synaptic curent   
%%

Cii=C{2};
Cie=C{3};
Cei=C{4};

D_ee=D{1};
D_ie=D{2};

threse=diag(w{1}'*w{1})/2+mu/2;            % firing threshold E neurons
thresi=diag(w{2}'*w{2})/2+mu/2;            % firing threshold I neurons

%% to speed up the integration

leak_e=1-lambda_e*dt;   % for leak current in E  
leak_i=1-lambda_i*dt;   % for leak current in I

noise_e=sigmav.*randn(N,T)*sqrt(2*dt);
noise_i=sigmav.*randn(Ni,T)*sqrt(2*dt);

ffe=w{1}'*s*dt;

%% integration

Ve=zeros(N,T);      % membrane potential
fe=zeros(N,T);      % spike train
re=zeros(N,T);      % filtered spike train
ze=zeros(N,T);      % filtered spike train
xhat_e=zeros(M,T);  % excitatory estimate

Vi=zeros(Ni,T);      % same for I neurons
fi=zeros(Ni,T);
ri=zeros(Ni,T);
xhat_i=zeros(M,T);

Ve(:,1)=randn(N,1)*2-12;  % initialization with random membrane potentials E
Vi(:,1)=randn(Ni,1)*2-12;  % I

for t=1:T-1
    
    % E neurons 
    Ve(:,t+1)=leak_e*Ve(:,t)+ ffe(:,t) - Cei*fi(:,t) + D_ee*ze(:,t)- delta_e*re(:,t)- mu*fe(:,t)+ noise_e(:,t);
   
    % I neurons 
    Vi(:,t+1)=leak_i*Vi(:,t) + Cie*fe(:,t) - Cii*fi(:,t) + delta_ie*D_ie*ze(:,t) - delta_i*ri(:,t)-mu*fi(:,t)+noise_i(:,t);  
    
    activation=Ve(:,t+1)>(threse+noise_e(:,t)); 
    if sum(activation)>0
        fe(:,t+1)=activation;
    end
    
    activation_i=Vi(:,t+1)>(thresi+noise_i(:,t)); 
    if sum(activation_i)>0
        fi(:,t+1)=activation_i;
    end
    
    ze(:,t+1)=(1-lambda_e*dt)*ze(:,t)+fe(:,t);                   % low-pass filtered spike train E
    re(:,t+1)=(1-alpha_e*dt)*re(:,t)+fe(:,t);                   % low-pass filtered spike train E
    xhat_e(:,t+1)=(1-lambda_e*dt)*xhat_e(:,t)+w{1}*fe(:,t+1);   % estimate E  
    
    ri(:,t+1)=(1-alpha_i*dt)*ri(:,t)+fi(:,t);                   % firing rate I
    xhat_i(:,t+1)=(1-lambda_i*dt)*xhat_i(:,t)+w{2}*fi(:,t+1);   % estimate I
    
end

fi=int8(fi);
fe=int8(fe);

end
