
close all
%clear all
%clc

simulation_type=1;              % [1~full rank contained, 2~full rank sustained, 3~spontaneous] 
savefig=0;

fignames={'activity_2A','activity_2B','activity_2C'};

if simulation_type<3
    stim_type=1;     %[1,2,3] for [first feature positive only, first feature positive and negative, no stimulus]
else
    stim_type=3;
end

%% parameters

M=3;                                   % number of features      
N=400;                                 % number of E neurons   

nsec=1;

tau_e=10;                              % time constant of the excitatory estimate  
tau_i=5;                               % time const I estimate 

tau_re=20;                             % time constant of the low-pass filtered spike train in E neurons
tau_ri=10;                             % time constant of the low-pass filtered spike train in I neurons  
   
a_mu=1.0;                                   % sets the strength of the regularizer
if simulation_type==1
    a_sigmav=1.5;                           % sets the strength of the noise 
else
    a_sigmav=1.8;
end

mu=a_mu*log(N);                             % quadratic cost constant
sigmav=a_sigmav/log(N);                      % noise intensity

dt=0.02;                                    % time step in ms     
q=4;                                        % ratio of E to I neurons
d=3;                                        % ratio of standard deviations for I to E decoding weights

%% set decoding weights w and the input s(t), compute connectivity weights C and D and the signal x(t)

gamma=[0.4,0.1,0.1;0.1,0.4,0.1;0.1,0.1,-0.4];   % defines the matrix B
aB=0.035;

B=(gamma'*gamma).*aB;                           % matrix B
%A=B-(eye(M,M)*(1/tau_e));                      % matrix A

T=(nsec*1000)./dt;
s=stim_fun(M,T,stim_type);

[w,C,D] = w_fun(M,N,q,d,B);

%% check properties

tau_vec=cat(1,tau_e,tau_i,tau_re, tau_ri);

if tau_e<tau_re
    disp('adaptation in E neurons')
elseif tau_e>tau_re
    disp('facilitation in E neurons')
else
    disp('no local currents in E neurons')
end
if tau_i<tau_ri
    disp('adaptation in I neurons')
elseif tau_i>tau_ri
    disp('facilitation in I neurons')
else
    disp('no local currents in I neurons')
end

display(issymmetric(B),'is B symmetric');

e = eig(B);
tol=length(e)*eps(max(e));

issemidef = all(e > -tol); 
display(issemidef,'is B positive semi-definite')

%% simulate network activity

[fe,fi,xhat_e,xhat_i,re,ri] =net_fun(dt,sigmav,mu,tau_vec,s,w,C,D);

%% plot input, spikes and pop. firing rate



figname=[fignames{simulation_type},'0'];
savefile=cd;
legend_on=0;

wi=w{2}(1,:);
we=w{1}(1,:);

pops=cell(4,1);
pops{1}=mean(ri(find(wi>0),:))*1000/tau_ri;
pops{2}=mean(re(find(we>0),:))*1000/tau_re;
pops{3}=mean(ri(find(wi<0),:))*1000/tau_ri;
pops{4}=mean(re(find(we<0),:))*1000/tau_re;

if simulation_type<3
    pos_vec=[0,0,14,10];
    
else
    pos_vec=[0,0,28,10];
end

plt_sign(fe,fi,pops,s,dt,we,wi,figname, savefig,savefile,pos_vec,legend_on)

%%
