
close all
clear all
clc

savefig=0;

stim_type=1;
legend_on=0
%% parameters

M=3;                                   % number of encoded features        
N=400;                                 % number of E neurons   

nsec=1;                                % duration of the trial in seconds 

tau_e=10;                              % time constant of the excitatory estimate  
tau_i=5;                               % time constant inhibitory estimate 

tau_re=20;                             % time constant of the low-pass filtered spike train in E neurons
tau_ri=10;                             % time constant of the low-pass filtered spike train in I neurons 
   
a_mu=1.0;                              % sets the strength of the regularizer     
a_sigma=1.5;                           % sets the noise intensity 
mu=a_mu*log(N);                        % constant of the quadratic regularizer
sigmav=a_sigma/log(N)                 % noise intensity spike generation

dt=0.02;                               % time step in ms     
q=4;                                   % ratio of E to I neurons
d=3;                                   % ratio of standard deviations for I to E decoding weights 

%% set decoding weights w and the input s(t), compute connectivity weights C and D and the signal x(t)

b1=[0.5,0.0,0.3];
aB=0.035;

B=(b1'*b1).*aB;
%A=B-(eye(M,M)*(1/tau_e));

T=(nsec*1000)./dt;
s=stim_fun(M,T,stim_type);

[w,C,D] = w_fun(M,N,q,d,B);
%%

tau_vec=cat(1,tau_e,tau_i,tau_re, tau_ri);

if tau_e<tau_re
    disp('adaptation in E neurons')
elseif tau_e>tau_re
    disp('facilitation in E neurons')
else
    disp('no local currents in E neurons')
end
if tau_i<tau_ri
    disp('adaptation in I neurons')
elseif tau_i>tau_ri
    disp('facilitation in I neurons')
else
    disp('no local currents in I neurons')
end

display(issymmetric(B),'is B symmetric');

e = eig(B);
tol=length(e)*eps(max(e));

issemidef = all(e > -tol); 
display(issemidef,'is B positive semi-definite')

%% simulate network activity

[fe,fi,xhat_e,xhat_i,re,ri] =net_fun(dt,sigmav,mu,tau_vec,s,w,C,D);

%% plot input, spikes and pop. firing rate


wi=w{2}(1,:);
we=w{1}(1,:);

pops=cell(4,1);
pops{1}=mean(ri(find(wi>0),:))*1000/tau_ri;
pops{2}=mean(re(find(we>0),:))*1000/tau_re;
pops{3}=mean(ri(find(wi<0),:))*1000/tau_ri;
pops{4}=mean(re(find(we<0),:))*1000/tau_re;

pos_vec=[0,0,10,9];
figname='activity_EE_rank1';
savefile=cd;

plt_sign(fe,fi,pops,s,dt,we,wi,figname, savefig,savefile,pos_vec,legend_on)


%%
