
close all
clear all
clc

stim_type=2;                           % [1 for only positive feature, 2 for positive and negative feature]

legend_on=1;
savefig=0;

%% parameters

M=3;                                   % number of encoded features        
N=400;                                 % number of E neurons   

nsec=1;                                % duration of the trial in seconds 

tau_e=10;                              % time constant of the excitatory estimate  
tau_i=10;                               % time constant inhibitory estimate 

tau_re=10;                             % time constant of the low-pass filtered spike train in E /membrane time constant E neurons
tau_ri=10;                             % time constant of the low-pass filtered spike train in I /membrane time constant I neurons 
   
a_mu=1;                                % sets the strength of the regularizer     
a_sigma=1;                             % sets the strength of the noise 
mu=a_mu*log(N);                        % constant of the quadratic regularizer
sigmav=a_sigma/log(N);                 % noise intensity spike generation

dt=0.02;                               % time step in ms     
q=4;                                   % ratio of E to I neurons
d=3;                                   % ratio of standard deviations for I to E decoding weights 

%% set decoding weights w, compute connectivity weights C and D 

B=zeros(M,M);

T=(nsec*1000)./dt;
s=stim_fun(M,T,stim_type);
%%

tau_vec=cat(1,tau_e,tau_i,tau_re, tau_ri);

if tau_e<tau_re
    disp('adaptation in E neurons')
elseif tau_e>tau_re
    disp('facilitation in E neurons')
else
    disp('no local currents in E neurons')
end
if tau_i<tau_ri
    disp('adaptation in I neurons')
elseif tau_i>tau_ri
    disp('facilitation in I neurons')
else
    disp('no local currents in I neurons')
end

%% simulate network activity
tic
[w,C,D] = w_fun(M,N,q,d,B);

[fe,fi,xhat_e,xhat_i,re,ri] =net_fun(dt,sigmav,mu,tau_vec,s,w,C,D);
toc
%% plot input, spikes and pop. firing rate


pos_vec=[0,0,10,9];
savefile=cd;

wi=w{2}(1,:);
we=w{1}(1,:);

pops=cell(4,1);
pops{1}=mean(ri(find(wi>0),:))*1000/tau_ri;
pops{2}=mean(re(find(we>0),:))*1000/tau_re;
pops{3}=mean(ri(find(wi<0),:))*1000/tau_ri;
pops{4}=mean(re(find(we<0),:))*1000/tau_re;


figname='activity_simple_N400';
plt_sign(fe,fi,pops,s,dt,we,wi,figname, savefig,savefile,pos_vec,legend_on)


%%
