function [] = plt_sign(fe,fi,pops,s,dt,we,wi,figname, savefig,savefile,pos_vec,legend_on)

%%
T=size(fe,2);
nsec=(T*dt)/1000;
N=size(fe,1);

%% figure parameters

fs=12;
ms=4;
lw=1.7;
lwa=1;
tl=0.01;

grid=(1:N)'*ones(1,T);  % grid for spikes
tindex=nsec*(1:T)/T*1000;

Ni=size(fi,1);
gridI=N+(1:Ni)'*ones(1,T);

% ticks

maxs=2.5;
mins=-maxs;

xt=0:500:1000;                         % in milliseconds
ytr=0:20:60;

red=[0.85,0.32,0.1];
blue=[0,0.48,0.74];
col={'m','k',red,blue};

pose=repmat(int8((we>0))',1,T);
nege=repmat(int8((we<0))',1,T);
posi=repmat(int8((wi>0))',1,T);
negi=repmat(int8((wi<0))',1,T);

leg={'$w^I_{1i}>0$','$w^E_{1i}>0$','$w^I_{1i}<0$','$w^E_{1i}<0$'};

%% plot

H=figure('name',figname);

subplot(5,1,1)
plot(tindex,s(1,:),'color','k','linewidth',lw+0.5) 

line([tindex(1), tindex(end)], [0,0],'color',[0.2,0.2,0.2,0.5])
ylim([mins,maxs])
xlim([0,nsec*1000])

set(gca,'XTick',xt);
set(gca,'YTick',[0,2]);
set(gca,'XTickLabel',[]);
set(gca,'YTickLabel',[0,2],'Fontsize',fs)

ylabel('s_1(t)','Fontsize',fs)

set(gca,'LineWidth',lwa,'TickLength',[tl tl]);
set(gca,'TickDir','out');
box off
%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(5,1,[2,3])
hold on
plot(tindex,(gridI.*single(fi.*posi))','.','color',col{1},'markersize',ms);
plot(tindex,(grid.*single(fe.*pose))','.','color',col{2},'markersize',ms);
plot(tindex,(gridI.*single(fi.*negi))','.','color',col{3},'markersize',ms);
plot(tindex,(grid.*single(fe.*nege))','.','color',col{4},'markersize',ms);

hold off
box off

if legend_on==1
    for ii=1:4
        text(0.75,0.9-(ii-1)*0.25,leg{ii},'units','normalized','color',col{ii},'Fontsize',fs-1,'Interpreter','latex')
    end
end

set(gca,'xtick',xt);
set(gca,'XTickLabel',[])

xlim([0,nsec*1000])
ylim([0.5 N+Ni+0.5])

set(gca,'XTick',xt);
set(gca,'XTickLabel',[])
set(gca,'YTick',N)
set(gca,'YTickLabel',N,'Fontsize',fs)

set(gca,'LineWidth',lwa,'TickLength',[tl tl]);
set(gca,'TickDir','out');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(5,1,[4 5])
hold on       
for ii=1:4
    plot(tindex,pops{ii},'color',col{ii},'linewidth',lw)            % firing rate [spikes/sec]
end
hold off
box off

ylabel('f.rate','Fontsize',fs)
set(gca,'YTick',ytr);
set(gca,'YTickLabel',ytr,'Fontsize',fs)

op=get(gca,'OuterPosition');
set(gca,'OuterPosition',[op(1)+0.0 op(2)+0.0 op(3)-0.0 op(4)-0.0]);

xlim([0,nsec*1000])
ylim([0,45])

set(gca,'XTick',xt);
set(gca,'XTickLabel',xt,'Fontsize',fs)

set(gca,'LineWidth',lwa,'TickLength',[tl tl]);
set(gca,'TickDir','out');

%%%%%%%%%%%%%%%%%%%%%%%
axes

h1 = xlabel ('time [ms]','units','normalized','Position',[0.5,-0.06,0],'fontsize',fs);
set(gca,'Visible','off')
set(h1,'visible','on')

set(H, 'Units','centimeters', 'Position', pos_vec)
set(H,'PaperPositionMode','Auto','PaperUnits', 'centimeters','PaperSize',[pos_vec(3), pos_vec(4)]) % for saving in the right size

if savefig==1
    print(H,[savefile,figname],'-dpng','-r300');
end

end

