#!/bin/bash

# Load python virtualenv for local computer
virtualenv venv
source venv/bin/activate
pip3 install -r requirements.txt

# Comment if using GPU
export CUDA_VISIBLE_DEVICES=-1

# Begin experiment
for SEED in {1..1}
do
    python3.6 main.py \
    --env-name "IPD-v0" \
    --seed $SEED \
    --opponent-shaping \
    --prefix ""

    python3.6 main.py \
    --env-name "IPD-v0" \
    --seed $SEED \
    --opponent-shaping \
    --test-mode \
    --prefix "test"
done
