import sys
sys.path.append("..")

from transformers import (
    RobertaTokenizer,
    RobertaConfig
)
from models import *
from process_fn import triple_process_fn, triple2dual_process_fn

default_train_path = "/yourdefaultpath/100k_sample_head.tsv"
default_process_fn = triple_process_fn

class MSMarcoConfig:
    def __init__(self, name, model, train_path=default_train_path, process_fn=default_process_fn, use_mean=True, tokenizer_class=RobertaTokenizer, config_class=RobertaConfig):
        self.name = name
        self.train_path = train_path
        self.process_fn = process_fn
        self.model_class = model
        self.use_mean = use_mean
        self.tokenizer_class = tokenizer_class
        self.config_class = config_class

configs = [
    MSMarcoConfig(name = "bm25_nll_first_ln",
                model = RobertaDot_NLL_LN,
                use_mean = False,
                ),
]

MSMarcoConfigDict = {cfg.name:cfg for cfg in configs}