export CUBLAS_WORKSPACE_CONFIG=:4096:8
export SEED=0
export PYTHONHASHSEED=$SEED
export TASK_NAME=rte
export TQDM_DISABLE=1

torchrun \
    --nnodes=1 --nproc-per-node=1 --rdzv_backend=c10d --rdzv_endpoint=localhost:0 \
    run_glue.py \
    --model_name_or_path microsoft/deberta-v3-base \
    --task_name $TASK_NAME \
    --do_train --do_eval \
    --max_seq_length 320 \
    --per_device_train_batch_size 32 \
    --learning_rate 8e-4 \
    --num_train_epochs 10 --warmup_steps 50 \
    --cls_dropout 0.2 --weight_decay 0.01 \
    --output_dir ./output/$TASK_NAME/ --overwrite_output_dir \
    --logging_steps 10 \
    --eval_strategy epoch \
    --save_strategy epoch \
    --lora_r 8 --lora_alpha 8 \
    --target_modules all-linear \
    --seed $SEED \
    --refactor True --use_scalar False --reflora_warmup 150 \
