# Environment

First, setup the environment. 

```bash
conda create -n [env_name] python=3.12
conda activate [env_name]
# One can also run `bash setup_env.sh` to install packages
pip install -r requirements.txt
pip install -e reflora
```

# GLUE benchmark

The following commands reproduce the results for the GLUE benchmark. 

```bash
cd glue
bash scripts/[dataset].sh
```

# Commonsense reasoning

The next commands are used to run experiments on the commonsense reasoning datasets

```bash
cd commonsense_reasoning
```

Then, download data from [LLM-adapters](https://github.com/AGI-Edgerunners/LLM-Adapters/tree/main), and prepare the data as follows (the same way with LLM-adapters)

```bash
/commonsense_reasoning/
|-- dataset/
|   |-- ARC-Challenge/
|   |-- ARC-Easy/
|   |-- boolq/
|   |-- ... # other datasets
|
|-- ft-training_set/
    |-- commonsense_170k.json
```

Now, you can run the experiments via

```bash
bash scripts/llama_7B.sh
bash scripts/llama2_7B.sh
bash scripts/llama3_8B.sh
```

