#!/bin/bash

#cd ../..

# custom config

# trainer
TRAINER=$1
CFG=$2

# dataset
DATASET=$3
DATA=$4
SHOTS=$5
SUB=new

SEED=$6
LOADEP=$7

# reg config
REG_CFG=$8
REG_DIR=$9

# calirbation config
CALIBRATION_CFG=${10}

COMMON_DIR=${DATASET}/shots_${SHOTS}/${TRAINER}/${CFG}/${REG_DIR}/seed${SEED}

MODEL_DIR=output/base2new/train_base/${COMMON_DIR}
DIR=output/base2new/test_${SUB}/${COMMON_DIR}
if [ -d "$DIR" ]; then
    echo "Evaluating model"
    echo "Results are available in ${DIR}. Resuming..."
    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --calibration-config "${CALIBRATION_CFG}" \
    --reg-config "${REG_CFG}" \
    --output-dir ${DIR} \
    --model-dir ${MODEL_DIR} \
    --load-epoch ${LOADEP} \
    --eval-only \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES ${SUB}
else
    echo "Evaluating model"
    echo "Runing the first phase job and save the output to ${DIR}"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --calibration-config "${CALIBRATION_CFG}" \
    --reg-config "${REG_CFG}" \
    --output-dir ${DIR} \
    --model-dir ${MODEL_DIR} \
    --load-epoch ${LOADEP} \
    --eval-only \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES ${SUB}
fi