#!/bin/bash

#cd ../..

# custom config

# trainer
TRAINER=$1
CFG=$2

# dataset
DATASET=$3
DATA=$4
SHOTS=$5
SUB=base

SEED=$6

# reg config
REG_CFG=$7
REG_DIR=$8


# calirbation config
CALIBRATION_CFG=$9


DIR=output/base2new/train_base/${DATASET}/shots_${SHOTS}/${TRAINER}/${CFG}/${REG_DIR}/seed${SEED}

if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR}. Resuming..."
    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --calibration-config "${CALIBRATION_CFG}" \
    --reg-config "${REG_CFG}" \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES ${SUB}
else
    echo "Run this job and save the output to ${DIR}"
    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --calibration-config "${CALIBRATION_CFG}" \
    --reg-config "${REG_CFG}" \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES ${SUB}
fi