
# README (ICLR anonymous submission)

## Overview

This repository contains the code used in the work:
**“Structuring Hidden Features via Clustering of Unit-Level Activation Patterns”** (submitted to ICLR 2025).

The implementation builds upon **PyTorch Image Models (timm)**.

> **Anonymity:** This package is prepared for double-blind review. No author or affiliation identifiers are included.

---

## Installation

```bash
conda env create -f environment.yml
conda activate timm
```

---

## Training

Example YAML configs are provided for three datasets: **Synthetic**, **CIFAR-10**, and **ImageNet-1k**.

### Synthetic

```bash
python train.py --config experiments/synthetic_base.yaml
python train.py --config experiments/synthetic_structure.yaml
```

### CIFAR-10

```bash
python train.py --config experiments/cifar10_base.yaml
python train.py --config experiments/cifar10_structure.yaml
```

> Data: place the CIFAR-10 files under `~/data/` (e.g., `~/data/cifar-10-batches-py`).
> If the folder is missing, run with `--dataset-download` to auto-download.

### ImageNet-1k

Run with different seeds for reproducibility:

```bash
python train.py --config experiments/imagenet1k_base.yaml --seed 0
python train.py --config experiments/imagenet1k_structure.yaml --seed 0
```

(Repeat with `--seed 1`, `--seed 2`)

> Data: place the dataset under `~/data/imagenet1k` (e.g., `~/data/imagenet1k/ilsvrc___imagenet-1k`).
> Alternatively, you can use the Hugging Face dataset `ILSVRC/imagenet-1k` (works with `dataset: hfds/ILSVRC/imagenet-1k`).

---

## Citation

Please cite the paper once the review process is complete. For now (double-blind), you may use:

```
Anonymous Authors. Structuring Hidden Features via Clustering of Unit-Level Activation Patterns. Submitted to ICLR 2025.
```

---

## License

This repository contains two parts:

1. **Original contributions (this work):**
   Provided under ICLR’s anonymous submission policy.

   > License: For anonymous review only. Full license information will be provided upon publication.

2. **Third-party components:**
   Portions of this code are adapted from [PyTorch Image Models (timm)](https://github.com/huggingface/pytorch-image-models),
   licensed under the Apache License, Version 2.0.
   See [LICENSE-timm](LICENSE-timm) for details.

