""" Layer difference results

Copyright (c) 2025 Anonymous Authors
"""
import os
import pandas as pd


def get_layer_difference_logging_list():
    train_logging_list = ['last.pth.tar']
    results_logging_list = ['similarity_0_0.csv', 'similarity-threshold_0_0.csv']
    
    return train_logging_list, results_logging_list


def _layer_difference_comparison(file1, file2, name1, name2, result_file):
    # Read both CSV files
    df1 = pd.read_csv(file1, header=None)
    df2 = pd.read_csv(file2, header=None)

    # Extract the last row from each DataFrame
    last_row1 = df1.iloc[-1]
    last_row2 = df2.iloc[-1]
    diff = last_row1 - last_row2

    # Combine into a single DataFrame
    final_df = pd.DataFrame({
        name1: last_row1,
        name2: last_row2,
        'difference': diff
    })
    final_df = final_df.iloc[:-1]

    # Reset index to turn the index (column names) into a column
    final_df.reset_index(inplace=True)
    final_df.rename(columns={'index': 'Parameter'}, inplace=True)

    # Save to CSV
    final_df.to_csv(result_file, index=False)
    return


def layer_difference_comparison(exp_label_list, results_list, output_directory):
    
    # results_list 
    file_name = 'similarity_0_0.csv'
    name1, name2 = exp_label_list
    path1, path2 = results_list[0], results_list[1]
    file1, file2 = os.path.join(path1, file_name), os.path.join(path2, file_name)
    output_file = os.path.join(output_directory, 'layer-difference-comparsion.csv')
    _layer_difference_comparison(file1, file2, name1, name2, output_file)

    # results_list 
    file_name = 'similarity-threshold_0_0.csv'
    name1, name2 = exp_label_list
    path1, path2 = results_list[0], results_list[1]
    file1, file2 = os.path.join(path1, file_name), os.path.join(path2, file_name)
    output_file = os.path.join(output_directory, 'threshold-layer-difference-comparsion.csv')
    _layer_difference_comparison(file1, file2, name1, name2, output_file)

    return