""" Logging hardware for reproduction

Copyright (c) 2025 Anonymous Authors
"""
import os
import json
import platform
import torch


def get_cpu_name():
    return platform.processor()


def get_gpu_names():
    gpu_names = []
    if torch.cuda.is_available():
        for i in range(torch.cuda.device_count()):
            gpu_names.append(torch.cuda.get_device_name(i))
    else:
        gpu_names.append("No GPU available")
    return gpu_names


def save_hardware(output_dir):
    os.makedirs(output_dir, exist_ok=True)

    hardware_info = {
        "cpu_name": get_cpu_name(),
        "gpu_names": get_gpu_names()
    }

    output_path = os.path.join(output_dir, "hardware.json")
    with open(output_path, "w") as f:
        json.dump(hardware_info, f, indent=4)
