#!/bin/bash

CONFIG_FILE=""

while getopts "c:" opt; do
  case "$opt" in
    c) CONFIG_FILE="$OPTARG" ;;
    *) echo "Usage: $0 -c <config_file>"; exit 1 ;;
  esac
done

REPO_PATH=${WORK}/repos/colpali

module purge
module load arch/h100 cuda/12.4.1
source .venv/bin/activate

# Cluster-specific settings
export OMP_NUM_THREADS=64
export MKL_NUM_THREADS=64
export NUMEXPR_NUM_THREADS=64

# We are on an offline partition
export HF_DATASETS_OFFLINE=1
export TRANSFORMERS_OFFLINE=1

# be careful about the cache folder for Wandb
wandb offline
export WANDB_DIR="${SCRATCH}/wandb"

# Load the environment
export HF_HOME=$SCRATCH/hf_home
export ACCELERATE_HOME=$HF_HOME/accelerate

ACCELERATE_CONFIG_FILE="$ACCELERATE_HOME/accelerate_config_1n.yml"

accelerate launch \
        --config_file $ACCELERATE_CONFIG_FILE \
        train.py \
        --config $CONFIG_FILE