#!/bin/bash

CONFIG_FILE=""
pwd=$(pwd)

while getopts "c:" opt; do
  case "$opt" in
    c) CONFIG_FILE="$pwd/$OPTARG" ;;
    *) echo "Usage: $0 -c <config_file>"; exit 1 ;;
  esac
done

echo "Using config: ${CONFIG_FILE}"

REPO_PATH=$WORK/repos/smollm/vision
cd $REPO_PATH

module purge
module load arch/h100 cuda/12.4.1
source .venv/bin/activate

# Cluster-specific settings
export OMP_NUM_THREADS=64
export MKL_NUM_THREADS=64
export NUMEXPR_NUM_THREADS=64
export TOKENIZERS_PARALLELISM=false

# We are on an offline partition
export HF_DATASETS_OFFLINE=1
export TRANSFORMERS_OFFLINE=1

# be careful about the cache folder for Wandb
export WANDB_MODE=offline

# Load the environment
export HF_HOME=$SCRATCH/hf_home
export ACCELERATE_HOME=$HF_HOME/accelerate

ACCELERATE_CONFIG_FILE="${ACCELERATE_HOME}/zero1.yml"
PYTHONPATH=$(pwd) accelerate launch \
        --config_file $ACCELERATE_CONFIG_FILE \
        m4/training/main.py \
          --config $CONFIG_FILE