#!/bin/bash
set -euo pipefail

SLURM_SCRIPT=launch_benchmark.slurm

# get the -m flag
while getopts "m:" opt; do
  case $opt in
    m) MODEL_LIST="$OPTARG" ;;
    \?) echo "Invalid option: -$OPTARG" >&2; exit 1 ;;
    :) echo "Option -$OPTARG requires an argument." >&2; exit 1 ;;
  esac
done

if [[ ! -f "$SLURM_SCRIPT" ]]; then
  echo "Error: SLURM script '$SLURM_SCRIPT' not found."
  exit 1
fi

if [[ ! -f "$MODEL_LIST" ]]; then
  echo "Error: Model list '$MODEL_LIST' not found."
  exit 1
fi

# Loop over each non-empty, non-comment line in models.txt
while read -r line || [[ -n "$line" ]]; do
  # Skip empty lines and lines starting with #
  [[ -z "${line// /}" || "${line:0:1}" == "#" ]] && continue

  MODEL_NAME="$line"
  echo "Submitting job for model: $MODEL_NAME"

  # Submit the job, passing MODEL into the SLURM script
  sbatch $SLURM_SCRIPT -m $MODEL_NAME
done < "$MODEL_LIST"