#!/usr/bin/env bash
set -euo pipefail

# Default empty (will only be added if provided)
HF_TOKEN="${HF_TOKEN:-}"

# Parse arguments
if [ $# -eq 0 ]; then usage; fi
while [[ $# -gt 0 ]]; do
  case "$1" in
    --root)
      ROOT_DIR="$2"; shift 2;;
    *)
      echo "Unknown option: $1"; usage;;
  esac
done

if [[ -z "${ROOT_DIR:-}" ]]; then
  echo "Error: --root is required"
  usage
fi

if [[ -z "$HF_TOKEN" ]]; then
  echo "Error: HF token not set; pass --hf-token or set \$HF_TOKEN"
  exit 1
fi

source $WORK/.venv/bin/activate

# Find every directory named "final" under ROOT_DIR
while IFS= read -r dir; do
  echo -e "\n---------------------------------------\n"
  echo "➡️  Pushing adapter in: $dir"
  cmd=(python push_adapter_to_hub.py --adapter-dir "$dir" --private)
  "${cmd[@]}"
done < <(find "$ROOT_DIR" -type d -name final)
