#!/bin/bash
set -euo pipefail

# get the -s and -m flags
while getopts "m:" opt; do
  case $opt in
    m) MODEL_LIST="$OPTARG" ;;
    \?) echo "Invalid option: -$OPTARG" >&2; exit 1 ;;
    :) echo "Option -$OPTARG requires an argument." >&2; exit 1 ;;
  esac
done

while read -r line || [[ -n "$line" ]]; do
  # Skip empty lines or lines starting with '#'
  [[ -z "${line// /}" || "${line:0:1}" == "#" ]] && continue

  MODEL_ID="$line"
  echo "Downloading model: ${MODEL_ID}"
  huggingface-cli download "${MODEL_ID}"
done < "${MODEL_LIST}"
