################################################################################
# training/utils/type_checking.py
#
# 
# 
# 2023
#
# Utility functions for type checking and type messages.

def check_if_type(
    # The value to check.
    x,
    # The expected type of the value.
    t,
    # The variable name of the value.
    name = "value"
  ):
  assert isinstance(x, t), \
    f"{name} must be a {t.__name__}."

def check_if_type_or_none(
    # The value to check.
    x,
    # The expected type of the value.
    t,
    # The variable name of the value.
    name = "value"
  ):
  assert isinstance(x, t) or x is None, \
    f"{name} must be either a {t.__name__} or None."