## <u>So</u>undness and <u>Co</u>mpleteness

### Installation
1. Install pre-compiled `mmcv-full` following the [official instructions](https://mmcv.readthedocs.io/en/latest/get_started/installation.html).
2. `pip install -e .` (Do not miss the dot `.`). Developers please run `pip install -e ".[dev]"`.
3. (Optional, for developers only ) Install pre-commit hooks via `pip install pre-commit && pre-commit install`.


### Note
1. Due to the file size limit on OpenReview, we do not include the dataset in the code when submitting it as the supplementary material.
2. The retraining experiments are conducted using a third-party codebase.

### Code structure

#### Scripts for running experiments
The scripts are under `tools/` directory.
* `run_vision_completeness.py` is the script for completeness evaluation.
* `run_vision_soundness.py` is the script for soundness evaluation.

#### Configuration files
The configuration files are under `configs` directory.

#### Library
The library is under `soco/` directory.
* `soco/classifiers/` contains the function for building `mmcls` classifiers.
* `soco/imputations/` contains the imputation methods.
* `soco/datasets/` contains the datasets and image transformation pipelines.
* `soco/metrics/` contains the classes for evaluating soundness and completeness.
* `soco/utils/` contains some utility functions.
