data_type = 'ImageFolder'
data_root = 'data/small_imagenet/'

img_norm_cfg = dict(mean=(0.485, 0.456, 0.406), std=(0.229, 0.224, 0.225))

test_pipeline = [
    dict(type='Resize', height=224, width=224),
    dict(type='Normalize', **img_norm_cfg),
    dict(type='ToTensorV2'),
]

data = dict(
    data_loader=dict(
        batch_size=8,
        shuffle=False,
        num_workers=8,
    ),
    test=dict(
        type=data_type,
        img_root=data_root + 'images/',
        pipeline=test_pipeline,
        smap_root=None,
        cls_to_ind_file=data_root + 'imagenet_cls_to_ind.json',
    ),
)

classifier = dict(num_classes=1000, pretrained=True, ckpt=None)
