import os.path as osp
from setuptools import find_packages, setup


def get_version(package_name: str) -> str:
    init_py_path = osp.join(
        osp.abspath(osp.dirname(__file__)), package_name, '__init__.py')
    init_py = open(init_py_path, 'r').readlines()
    version_line = [
        l.strip() for l in init_py  # noqa: E741
        if l.startswith('__version__')
    ][0]
    # get the version number without the double quote symbols:
    # e.g. 0.1.0 rather than "0.1.0"
    version = version_line.split('=')[-1].strip().strip("'")
    return version


setup(
    version=get_version(package_name='soco'),
    packages=find_packages(exclude=('tests', )),
)
