from ExperimentsHEA import Experiments,ExecutionMode
from QuantumDataGenarator import QuantumDataGenarator
import time 
from sklearn.model_selection import train_test_split
import json
import numpy as np

if __name__ == '__main__':

    # set the adam learning rate to 0.0035 for both
    # make sure appropriate observable are used
    
    number_of_qubits=6
    num_layers=2
    
    data,label = QuantumDataGenarator.mnist_binary_classification(
        number_of_qubits, 
        samples = 5000
    )
    X_train, X_test, y_train, y_test = train_test_split(
        data, 
        label,
        stratify=label, 
        test_size=0.2
    )
    
    '''
    Here we are keeping everything the same for each run, but we are not fixing the seed of the Qiskit circuit simulator. 
    Hence, we will get different outputs in each run based on the inherent randomness of the simulator (due to shot noise, 
    sampling fluctuations etc.), which allows us to estimate the empirical mean and standard deviation across runs.


    For experiment 1:
    We need to run for all the modes available under ExecutionMode and store the resultant mean mse and mean std. for the plotting. The one 
    for the nmPQC mitigation is shown below. 


    For experiment 2: 
    We need to run for ExecutionMode.MITIGATED only, but change the self.probs in ExperimentsHEA.py to reflect the value of p
    i.e. if p=1, self.probs=1; p=2 --> self.probs= 0.5; p=4 --> self.probs=0.25.


    For experiment 3:
    We need to run for mitigated versions only. The only difference here is when creating neurons we have to change three neurons lambda value 
    to reflect dynamic change in noise. uncomment the  # Needed for dynamic error scenario block in ExperimentsHEA.py before running simulation.

    Once all the runs are complete we can use Plotting.py to plot the outcome.
    '''
    
    filename = 'EM.json'
    
    num_times_to_run = 3
    
    mses=[]
    test_accuracy=[]
    for i in range(num_times_to_run):
        exp = Experiments(number_of_qubits,num_of_neurons,list_of_unitary,support_qubits,ExecutionMode.MITIGATED)
        acc_d,mse,acc_pred=exp.training_circuit(X_train, y_train,epochs=50, batches=50)
        mses.append(mse)
    
        accD, accP= exp.testing_circuit(X_test,y_test)
        test_accuracy.append(accP)
        
    print('MSE mean: ' ,np.mean(mses,axis=0)) 
    print('MSE std: ' ,np.std(mses,axis=0)) 
    print('Test Acc: ' ,np.mean(test_accuracy)) 
    # end = time.time()
    
    data = {
        'Mse_mean': np.mean(mses,axis=0).tolist(),
        'Mse_std': np.std(mses,axis=0).tolist()
    }
    
    with open(filename, 'w') as f:
        json.dump(data, f, indent=4)  # indent=4 → makes it pretty
    
    print("Data saved to ", filename)
