from qiskit.quantum_info import Pauli
from Tools import Tools
from qiskit.circuit.library import UnitaryGate

_pauli_cache = {}
unitary_cache ={}
def get_cached_pauli(label):
    """Pauli caching."""
    if label not in _pauli_cache:
        _pauli_cache[label] = Pauli(label)   
    return _pauli_cache[label]

def get_cached_unitary(theta, unitary_pauli_string):
    """Apply the unitary gate with caching."""
    cache_key = (theta, unitary_pauli_string)
    if cache_key not in unitary_cache:
        unitary_matrix = Tools.unitary_exponent(theta, unitary_pauli_string)
        unitary_cache[cache_key] = UnitaryGate(unitary_matrix, label=f'exp(i{unitary_pauli_string}){theta:.4f}')
    return unitary_cache[cache_key]