from qiskit_ibm_runtime.fake_provider import FakeJakartaV2
from qiskit_aer import AerSimulator
from qiskit_aer.noise import NoiseModel, QuantumError
from qiskit.quantum_info import Kraus, Operator
import numpy as np
from qiskit.quantum_info import Pauli
from itertools import product

def get_noise_induced_backend():
    # Pauli errors-  assuming same for all gates, van den berg focusing on 2 qubit gate more. Generated based on list error count and generated lambda value from Tools.
    qubits = 2  # For 2-qubit Pauli strings
    pauli_strings = Tools.generateAllPossiblePauliString(qubits, excludeIdentity=True)
    noise_values = Tools.randNoiseParameterInitiatization(len(pauli_strings))
    paulis = dict(zip(pauli_strings, noise_values))
    
    # Calculate ω and probability of applying each Pauli
    
    probs = {}
    for P, lam in paulis.items():
        omega = (1 + np.exp(-2 * lam)) / 2
        p = 1 - omega
        probs[P] = p
    
    labels = list(probs.keys())
    pks = [probs[L] for L in labels]
    
    kraus_ops = []
    
    for mask in product([0, 1], repeat=len(labels)):
        # Build full operator for this combination
        op = Operator(np.eye(4)) 
        prob = 1.0
        for bit, label, p in zip(mask, labels, pks):
            if bit:
                pauli_op = Pauli(label).to_matrix()
                op = Operator(pauli_op) @ op
                prob *= p
            else:
                prob *= (1 - p)
        # Only add nonzero Kraus
        if prob > 0:
            kraus_ops.append(np.sqrt(prob) * op.data)
    
    # Define QuantumError using Kraus representation
    lindblad_kraus = QuantumError(Kraus(kraus_ops))
    # backend1 = FakeVigoV2() to get coupling map needed for the next step
    backend2 = FakeJakartaV2()
    #backend = AerSimulator(coupling_map = backend2.configuration().coupling_map, basis_gates=backend2.configuration().basis_gates)
    backend = AerSimulator.from_backend(backend2)
    noise_model = NoiseModel()
    noise_model.add_all_qubit_quantum_error(lindblad_kraus, ['cx'])
    backend.set_options(noise_model= noise_model,basis_gates=backend2.configuration().basis_gates)    
    return backend