import torch
import pickle as pkl

from arithmetic_mod7.model import ParseModel
from arithmetic_mod7.data import Generator, token_ids, evaluate_one_arithmetic


EVALUATION = True

batch_size = 256
g = Generator(length=20)
model = ParseModel(len(token_ids))
optim = torch.optim.Adam(model.parameters(), lr=0.001)


if EVALUATION:
    ckpt = torch.load("arithmetic_mod7/model.pth")
    toload_state_dict = ckpt["model"]
    model.load_state_dict(toload_state_dict)


step = 0
loss_list = list()
correct_list = list()
while step < 50000:
    step += 1
    if step % 1000 == 0:
        correct = dict()
        correct[20] = 0.1 * sum([evaluate_one_arithmetic(model, length=20) for _ in range(10)])
        correct[30] = 0.1 * sum([evaluate_one_arithmetic(model, length=30) for _ in range(10)])
        correct[40] = 0.1 * sum([evaluate_one_arithmetic(model, length=40) for _ in range(10)])
        correct[50] = 0.1 * sum([evaluate_one_arithmetic(model, length=50) for _ in range(10)])
        correct[60] = 0.1 * sum([evaluate_one_arithmetic(model, length=60) for _ in range(10)])
        correct[100] = 0.1 * sum([evaluate_one_arithmetic(model, length=100) for _ in range(10)])
        correct[200] = 0.1 * sum([evaluate_one_arithmetic(model, length=200) for _ in range(10)])
        correct[500] = 0.1 * sum([evaluate_one_arithmetic(model, length=500) for _ in range(10)])
        correct[1000] = 0.1 * sum([evaluate_one_arithmetic(model, length=1000) for _ in range(10)])
        correct_list.append(correct)
        print("correct", correct)
        pkl.dump(correct_list, open("arithmetic_mod7/result.pkl", "wb"))

        state = {"model": model.state_dict()}
        torch.save(state, "arithmetic_mod7/model.pth")

    if EVALUATION:
        continue

    x, y, mask = list(), list(), list()
    for _ in range(batch_size):
        _x, _cot, _x_onehot, _y, _mask = next(g)
        x.append(_x_onehot)
        y.append(_y)
        mask.append(_mask)
    x = torch.tensor(x, dtype=torch.float)
    y = torch.tensor(y, dtype=torch.int)
    mask = torch.tensor(mask, dtype=torch.float32)
    out, dist, loss = model(x, mask, y)
    loss = loss.mean()
    total_loss = loss
    loss_list.append(loss.item())
    if step % 10 == 0:
        print(f"step {step}, loss {sum(loss_list[-10:]) / 10}")

    optim.zero_grad()
    total_loss.backward()
    optim.step()


if not EVALUATION:
    state = {"model": model.state_dict()}
    torch.save(state, "arithmetic_mod7/model.pth")
