import numpy as np
import torch
import pickle as pkl

from one_line_multiplication.model import ParseModel
from one_line_multiplication.data import Generator, token_ids, evaluate_one_line_multiplication


batch_size = 256
g = Generator(maximum=5)
model = ParseModel(len(token_ids))
optim = torch.optim.Adam(model.parameters(), lr=0.0001)


step = 0
loss_list = list()
correct_list = list()
while step < 50000:
    # break
    step += 1
    x, y, mask = list(), list(), list()
    for _ in range(batch_size):
        _x, _cot, _x_onehot, _y, _mask = next(g)
        x.append(_x_onehot)
        y.append(_y)
        mask.append(_mask)
    x = torch.tensor(x, dtype=torch.float)
    y = torch.tensor(y, dtype=torch.int)
    mask = torch.tensor(mask, dtype=torch.float32)
    out, dist, loss = model(x, mask, y)
    loss = loss.mean()
    total_loss = loss
    loss_list.append(loss.item())
    if step % 10 == 0:
        print(f"step {step}, loss {sum(loss_list[-10:]) / 10}")

    optim.zero_grad()
    total_loss.backward()
    optim.step()

    if step % 100 == 0:
        correct = dict()
        correct[5] = 0.1 * sum([evaluate_one_line_multiplication(model, maximum=5) for _ in range(10)])
        correct[6] = 0.1 * sum([evaluate_one_line_multiplication(model, maximum=6) for _ in range(10)])
        correct[7] = 0.1 * sum([evaluate_one_line_multiplication(model, maximum=7) for _ in range(10)])
        correct[8] = 0.1 * sum([evaluate_one_line_multiplication(model, maximum=8) for _ in range(10)])
        correct[9] = 0.1 * sum([evaluate_one_line_multiplication(model, maximum=9) for _ in range(10)])
        correct[10] = 0.1 * sum([evaluate_one_line_multiplication(model, maximum=10) for _ in range(10)])
        correct_list.append(correct)
        print("correct_list", correct_list)
        pkl.dump(correct_list, open("one_line_multiplication/result.pkl", "wb"))


state = {"model": model.state_dict()}
torch.save(state, "one_line_multiplication/model.pth")


# ckpt = torch.load("one_line_multiplication/model.pth")
# toload_state_dict = ckpt["model"]
# model.load_state_dict(toload_state_dict)

