import numpy as np
import torch
import pickle as pkl

from two_line_addition.model import ParseModel
from two_line_addition.data import Generator, token_ids, evaluate_two_line_addtion


import ray
ray.init()


EVALUATION = True


batch_size = 256
g = Generator(length=7)
model = ParseModel(len(token_ids))
optim = torch.optim.Adam(model.parameters(), lr=0.00005)

if EVALUATION or True:
    ckpt = torch.load("two_line_addition/model.pth")
    toload_state_dict = ckpt["model"]
    model.load_state_dict(toload_state_dict)


step = 0
loss_list = list()
correct_list = list()
correct = None
while step < 50000:
    step += 1
    if step % 1000 == 0:
        if correct is not None:
            correct = {k: 0.1 * sum(ray.get(v)) for k, v in correct.items()}
            correct_list.append(correct)
            print("correct", correct)
            pkl.dump(correct_list, open("two_line_addition/result.pkl", "wb"))

        correct = dict()
        correct[7] = [ray.remote(evaluate_two_line_addtion).remote(model, length=7) for _ in range(10)]
        correct[8] = [ray.remote(evaluate_two_line_addtion).remote(model, length=8) for _ in range(10)]
        correct[9] = [ray.remote(evaluate_two_line_addtion).remote(model, length=9) for _ in range(10)]
        correct[10] = [ray.remote(evaluate_two_line_addtion).remote(model, length=10) for _ in range(10)]
        correct[15] = [ray.remote(evaluate_two_line_addtion).remote(model, length=15) for _ in range(10)]
        correct[20] = [ray.remote(evaluate_two_line_addtion).remote(model, length=20) for _ in range(10)]
        correct[30] = [ray.remote(evaluate_two_line_addtion).remote(model, length=30) for _ in range(10)]
        correct[40] = [ray.remote(evaluate_two_line_addtion).remote(model, length=40) for _ in range(10)]
        correct[50] = [ray.remote(evaluate_two_line_addtion).remote(model, length=50) for _ in range(10)]

    if EVALUATION:
        continue

    input0, input1, output0, output1, mask = list(), list(), list(), list(), list()
    for _ in range(batch_size):
        _input0, _input1, _output0, _output1, _mask = next(g)
        input0.append(_input0)
        input1.append(_input1)
        output0.append(_output0)
        output1.append(_output1)
        mask.append(_mask)
    input0 = torch.tensor(input0, dtype=torch.float)
    input1 = torch.tensor(input1, dtype=torch.float)
    output0 = torch.tensor(output0, dtype=torch.float)
    output1 = torch.tensor(output1, dtype=torch.float)
    mask = torch.tensor(mask, dtype=torch.float32)
    out0, out1, dist0, dist1, loss = model(input0, input1, mask, output0, output1)
    loss = loss.mean()
    total_loss = loss
    loss_list.append(loss.item())
    if step % 10 == 0:
        print(f"step {step}, loss {sum(loss_list[-10:]) / 10}")

    optim.zero_grad()
    total_loss.backward()
    optim.step()


if not EVALUATION:
    state = {"model": model.state_dict()}
    torch.save(state, "two_line_addition/model.pth")
